/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.OfferController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.ExpirationDuration;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.OfferType;
import io.meeds.deeds.common.constant.RentalDuration;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TransactionStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.listerner.model.EventSerialization;
import io.meeds.deeds.common.model.DeedTenantOfferDTO;
import io.meeds.deeds.common.model.OfferFilter;
import io.meeds.deeds.common.service.AuthorizationCodeService;
import io.meeds.deeds.common.service.OfferService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import jakarta.servlet.Filter;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tomcat.util.buf.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={OfferController.class, DeedAuthenticationProvider.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ContextConfiguration(classes={WebSecurityConfig.class})
class OfferControllerTest {
    private static final String TEST_PASSWORD = "testPassword";
    private static final String TEST_USER = "testUser";
    @MockBean
    private OfferService deedTenantOfferService;
    @MockBean
    private AuthorizationCodeService authorizationCodeService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    OfferControllerTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void testGetOffersByNftId() throws Exception {
        String offerId = "offerId";
        long nftId = 2L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.deedTenantOfferService.getOffers((OfferFilter)ArgumentMatchers.any(), (Pageable)ArgumentMatchers.any(Pageable.class))).thenAnswer(invocation -> {
            Pageable pageable = (Pageable)invocation.getArgument(1, Pageable.class);
            return new PageImpl(Collections.singletonList(deedTenantOfferDTO), pageable, 1L);
        });
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers?networkId=1&nftId=" + nftId + "&networkId=1&address=0xAdr"), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.offers", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    void testGetOffersByOfferTypesAndCardTypes() throws Exception {
        String offerId = "offerId";
        long nftId = 2L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        List<DeedCard> cardTypes = Arrays.asList(DeedCard.COMMON, DeedCard.UNCOMMON);
        List<OfferType> offerTypes = Arrays.asList(OfferType.RENTING, OfferType.SALE);
        Mockito.when((Object)this.deedTenantOfferService.getOffers((OfferFilter)ArgumentMatchers.any(), (Pageable)ArgumentMatchers.any(Pageable.class))).thenAnswer(invocation -> {
            Pageable pageable = (Pageable)invocation.getArgument(1, Pageable.class);
            return new PageImpl(Collections.singletonList(deedTenantOfferDTO), pageable, 1L);
        });
        Object link = "/api/offers?networkId=1&address=0xAdr&";
        link = (String)link + StringUtils.join((Collection)cardTypes.stream().map(cardType -> "cardType=" + cardType.name()).collect(Collectors.toList()), (char)'&');
        link = (String)link + "&";
        link = (String)link + StringUtils.join((Collection)offerTypes.stream().map(offerType -> "offerType=" + offerType.name()).collect(Collectors.toList()), (char)'&');
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)link, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.offers", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", (Matcher)Matchers.notNullValue())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    void testGetOfferNotFound() throws Exception {
        long offerId = 2L;
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers/" + offerId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void testGetOffer() throws Exception {
        String offerId = "offerId";
        long nftId = 3L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.deedTenantOfferService.getOffer((String)ArgumentMatchers.eq((Object)offerId), (String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)deedTenantOfferDTO);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers/" + offerId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.notNullValue()));
    }

    @Test
    void testGetOfferWhenMeantToTenantAnonymously() throws Exception {
        String offerId = "offerId";
        long nftId = 3L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        deedTenantOfferDTO.setHostAddress("tenant");
        Mockito.when((Object)this.deedTenantOfferService.getOffer(offerId, null, false)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers/" + offerId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void testGetProtectedOfferAnonymously() throws Exception {
        String offerId = "offerId";
        long nftId = 3L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        deedTenantOfferDTO.setHostAddress("tenant");
        Mockito.when((Object)this.deedTenantOfferService.getOffer(offerId, null, false)).thenThrow(UnauthorizedOperationException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers/" + offerId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void testGetOfferWhenMeantToTenant() throws Exception {
        long nftId = 3L;
        String offerId = "offerId";
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        deedTenantOfferDTO.setHostAddress(TEST_USER);
        Mockito.when((Object)this.deedTenantOfferService.getOffer((String)ArgumentMatchers.eq((Object)offerId), (String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)deedTenantOfferDTO);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/offers/" + offerId), (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.notNullValue()));
    }

    @Test
    void testCreateOfferWithAnonymousUser() throws Exception {
        long nftId = 3L;
        String offerId = "offerId";
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/offers", (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("X-AUTHORIZATION", new Object[]{String.valueOf(1234L)}));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.never())).createRentingOffer((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (DeedTenantOfferDTO)ArgumentMatchers.any());
    }

    @Test
    void testCreateOfferWithUserWithoutVerificationCode() throws Exception {
        long nftId = 3L;
        String offerId = "offerId";
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/offers", (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.never())).createRentingOffer((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (DeedTenantOfferDTO)ArgumentMatchers.any());
    }

    @Test
    void testCreateOfferWithUserWithInvalidVerificationCode() throws Exception {
        long nftId = 3L;
        int code = 588865;
        String offerId = "offerId";
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(TEST_USER.toLowerCase(), code)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/offers", (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.never())).createRentingOffer((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (DeedTenantOfferDTO)ArgumentMatchers.any());
    }

    @Test
    void testCreateOfferWithUserWithValidVerificationCode() throws Exception {
        long nftId = 3L;
        String offerId = "offerId";
        String email = "email";
        int code = 588865;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        Mockito.when((Object)this.authorizationCodeService.validateAndGetData(TEST_USER.toLowerCase(), code)).thenReturn((Object)email);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/offers", (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.times((int)1))).createRentingOffer(TEST_USER.toLowerCase(), email, deedTenantOfferDTO);
    }

    @Test
    void testUpdateOfferWithAnonymousUser() throws Exception {
        String offerId = "offerId";
        long nftId = 3L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/offers/" + offerId), (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.never())).updateRentingOffer((String)ArgumentMatchers.any(), (DeedTenantOfferDTO)ArgumentMatchers.any());
    }

    @Test
    void testUpdateOfferWithUser() throws Exception {
        String offerId = "offerId";
        long nftId = 3L;
        DeedTenantOfferDTO deedTenantOfferDTO = this.newOffer(offerId, nftId);
        deedTenantOfferDTO.setId(offerId);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/offers/" + offerId), (Object[])new Object[0]).content(OfferControllerTest.asJsonString(deedTenantOfferDTO)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.times((int)1))).updateRentingOffer(TEST_USER, deedTenantOfferDTO);
    }

    @Test
    void testDeleteOfferWithAnonymousUser() throws Exception {
        String offerId = "offerId";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/offers/" + offerId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.never())).deleteRentingOffer((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    void testDeleteOfferWithUser() throws Exception {
        String offerId = "offerId";
        String transactionHash = "transactionHash";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/offers/" + offerId + "?transactionHash=" + transactionHash), (Object[])new Object[0]).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((OfferService)Mockito.verify((Object)this.deedTenantOfferService, (VerificationMode)Mockito.times((int)1))).deleteRentingOffer(TEST_USER, offerId, transactionHash);
    }

    private DeedTenantOfferDTO newOffer(String offerId, long nftId) {
        return new DeedTenantOfferDTO(offerId, nftId, nftId, DeedCity.ASHTARTE, DeedCard.UNCOMMON, "owner", null, "description", 5.0, 10.0, OfferType.RENTING, ExpirationDuration.ONE_DAY, ExpirationDuration.ONE_DAY.getDays(), RentalDuration.ONE_MONTH, RentalDuration.ONE_MONTH.getMonths(), NoticePeriod.ONE_MONTH, NoticePeriod.ONE_MONTH.getMonths(), RentalPaymentPeriodicity.ONE_YEAR, 1, 1.1, "0xTransaction", TransactionStatus.IN_PROGRESS, Instant.now(), Instant.now(), Instant.now(), Instant.now(), false, null, null, null, null);
    }

    public static String asJsonString(Object obj) {
        try {
            return EventSerialization.OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private RequestPostProcessor testUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)TEST_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("USER")});
    }
}

