/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.constant.Currency;
import io.meeds.dapp.elasticsearch.model.MeedTokenMetric;
import io.meeds.dapp.service.ExchangeService;
import io.meeds.dapp.service.MeedTokenMetricService;
import io.meeds.dapp.storage.MeedTokenMetricsRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.contract.MeedsToken;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={MeedTokenMetricService.class})
@TestPropertySource(properties={"meeds.blockchain.reserveValueEthereumAddresses=0xBa5e4D55CA96bf25c35Fc65D9251355Dcd120655,0x8f4660498E79c771f93316f09da98E1eBF94c576,0x70CAd5d439591Ea7f496B69DcB22521685015853", "meeds.blockchain.reserveValuePolygonAddresses=0x44D6d6aB50401Dd846336e9C706A492f06E1Bee4", "meeds.blockchain.lockedValueEthereumAddresses=0x44D6d6aB50401Dd846336e9C706A492f06E1Bcd4,0x960Bd61D0b960B107fF5309A2DCceD4705567070", "meeds.blockchain.lockedValuePolygonAddresses=0x6acA77CF3BaB0C4E8210A09B57B07854a995289a"})
class MeedTokenMetricServiceTest {
    private static final BigDecimal MEED_USD_EXCHANGE_RATE = BigDecimal.valueOf(2.5);
    private static final BigDecimal USD_EUR_EXCHANGE_RATE = BigDecimal.valueOf(0.5);
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private ExchangeService exchangeService;
    @MockBean
    private MeedTokenMetricsRepository meedTokenMetricsRepository;
    @MockBean(name="ethereumMeedToken")
    private MeedsToken ethereumToken;
    @MockBean(name="polygonMeedToken")
    private MeedsToken polygonToken;
    @Autowired
    private MeedTokenMetricService meedTokenMetricService;

    MeedTokenMetricServiceTest() {
    }

    @BeforeEach
    void init() {
        Mockito.reset((Object[])new MeedTokenMetricsRepository[]{this.meedTokenMetricsRepository});
        Mockito.when((Object)this.exchangeService.getMeedUsdPrice()).thenReturn((Object)MEED_USD_EXCHANGE_RATE);
        Mockito.when((Object)this.exchangeService.getExchangeRate(Currency.EUR)).thenReturn((Object)USD_EUR_EXCHANGE_RATE);
        Mockito.when((Object)this.exchangeService.getExchangeRate(null)).thenReturn((Object)BigDecimal.ONE);
    }

    @Test
    void testGetReserveBalances() {
        HashMap<String, BigDecimal> expectedReserveBalances = new HashMap<String, BigDecimal>();
        BigDecimal totalReserves = this.mockReserveBalances(expectedReserveBalances);
        Map reserveBalances = this.meedTokenMetricService.getReserveBalances();
        Assertions.assertEquals(expectedReserveBalances, (Object)reserveBalances);
        BigDecimal result = reserveBalances.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Assertions.assertEquals((Object)totalReserves, (Object)result);
    }

    @Test
    void testGetTotalSupply() {
        BigDecimal totalSupply = BigDecimal.valueOf(1997.190119975555);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)totalSupply);
        this.meedTokenMetricService.computeTokenMetrics();
        Assertions.assertEquals((Object)totalSupply, (Object)this.meedTokenMetricService.getTotalSupply());
    }

    @Test
    void testGetLockedBalances() {
        HashMap<String, BigDecimal> expectedLockedBalances = new HashMap<String, BigDecimal>();
        BigDecimal totallocked = this.mockLockedBalances(expectedLockedBalances);
        Map lockedBalances = this.meedTokenMetricService.getLockedBalances();
        Assertions.assertEquals(expectedLockedBalances, (Object)lockedBalances);
        BigDecimal result = lockedBalances.values().stream().reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Assertions.assertEquals((Object)totallocked, (Object)result);
    }

    @Test
    void testGetTotalLockedValue() {
        BigDecimal totalLockedBalance = this.mockLockedBalances(new HashMap<String, BigDecimal>());
        BigDecimal expectedTotalLockedValue = MEED_USD_EXCHANGE_RATE.multiply(totalLockedBalance);
        BigDecimal expectedTotalSupply = BigDecimal.valueOf(100L);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)expectedTotalSupply);
        this.meedTokenMetricService.computeTokenMetrics();
        BigDecimal totalLockedValue = this.meedTokenMetricService.getTotalValueLocked(null);
        BigDecimal totalLockedValueEur = this.meedTokenMetricService.getTotalValueLocked(Currency.EUR);
        Assertions.assertEquals((Object)expectedTotalLockedValue, (Object)totalLockedValue);
        Assertions.assertEquals((Object)expectedTotalLockedValue.multiply(USD_EUR_EXCHANGE_RATE), (Object)totalLockedValueEur);
    }

    @Test
    void testComputeTokenMetrics() {
        BigDecimal expectedTotalSupply = BigDecimal.valueOf(100L);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)expectedTotalSupply);
        HashMap<String, BigDecimal> expectedReserveBalances = new HashMap<String, BigDecimal>();
        BigDecimal expectedTotalReserves = this.mockReserveBalances(expectedReserveBalances);
        HashMap<String, BigDecimal> expectedLockedBalances = new HashMap<String, BigDecimal>();
        BigDecimal expectedTotalLocked = this.mockLockedBalances(expectedLockedBalances);
        BigDecimal expectedCirculatingSupply = expectedTotalSupply.subtract(expectedTotalReserves).subtract(expectedTotalLocked);
        this.meedTokenMetricService.computeTokenMetrics();
        MeedTokenMetric recentMetric = this.meedTokenMetricService.getRecentMetric();
        Assertions.assertNotNull((Object)recentMetric);
        Assertions.assertEquals((Object)expectedTotalSupply, (Object)recentMetric.getTotalSupply());
        Assertions.assertEquals(expectedReserveBalances, (Object)recentMetric.getReserveBalances());
        Assertions.assertEquals(expectedLockedBalances, (Object)recentMetric.getLockedBalances());
        Assertions.assertEquals((Object)expectedCirculatingSupply, (Object)recentMetric.getCirculatingSupply());
        ((MeedTokenMetricsRepository)Mockito.verify((Object)this.meedTokenMetricsRepository, (VerificationMode)Mockito.times((int)1))).save((Object)recentMetric);
    }

    @Test
    void testGetLastMetric() {
        BigDecimal expectedTotalSupply = BigDecimal.valueOf(100L);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)expectedTotalSupply);
        HashMap<String, BigDecimal> expectedReserveBalances = new HashMap<String, BigDecimal>();
        BigDecimal expectedTotalReserves = this.mockReserveBalances(expectedReserveBalances);
        HashMap<String, BigDecimal> expectedLockedBalances = new HashMap<String, BigDecimal>();
        BigDecimal expectedTotalLocked = this.mockLockedBalances(expectedLockedBalances);
        BigDecimal expectedCirculatingSupply = expectedTotalSupply.subtract(expectedTotalReserves).subtract(expectedTotalLocked);
        this.meedTokenMetricService.setRecentMetric(null);
        MeedTokenMetric recentMetric = this.meedTokenMetricService.getLastMetric(null);
        Assertions.assertNotNull((Object)recentMetric);
        Assertions.assertEquals((Object)expectedTotalSupply, (Object)recentMetric.getTotalSupply());
        Assertions.assertEquals(expectedReserveBalances, (Object)recentMetric.getReserveBalances());
        Assertions.assertEquals(expectedLockedBalances, (Object)recentMetric.getLockedBalances());
        Assertions.assertEquals((Object)expectedCirculatingSupply, (Object)recentMetric.getCirculatingSupply());
        MeedTokenMetric recentMetricEur = this.meedTokenMetricService.getLastMetric(Currency.EUR);
        Assertions.assertNotNull((Object)recentMetricEur);
        Assertions.assertEquals((Object)expectedTotalSupply, (Object)recentMetricEur.getTotalSupply());
        Assertions.assertEquals(expectedReserveBalances, (Object)recentMetricEur.getReserveBalances());
        Assertions.assertEquals(expectedLockedBalances, (Object)recentMetricEur.getLockedBalances());
        Assertions.assertEquals((Object)expectedCirculatingSupply, (Object)recentMetricEur.getCirculatingSupply());
    }

    @Test
    void testGetCirculatingSupply() {
        BigDecimal expectedTotalSupply = BigDecimal.valueOf(100L);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)expectedTotalSupply);
        BigDecimal expectedTotalReserves = this.mockReserveBalances(new HashMap<String, BigDecimal>());
        BigDecimal expectedTotalLocked = this.mockLockedBalances(new HashMap<String, BigDecimal>());
        BigDecimal expectedCirculatingSupply = expectedTotalSupply.subtract(expectedTotalReserves).subtract(expectedTotalLocked);
        this.meedTokenMetricService.computeTokenMetrics();
        BigDecimal circulatingSupply = this.meedTokenMetricService.getCirculatingSupply();
        Assertions.assertEquals((Object)expectedCirculatingSupply, (Object)circulatingSupply);
    }

    @Test
    void testGetMarketCapitalization() {
        BigDecimal expectedTotalSupply = BigDecimal.valueOf(100L);
        Mockito.when((Object)this.blockchainService.meedsTotalSupplyNoDecimals()).thenReturn((Object)expectedTotalSupply);
        BigDecimal expectedTotalReserves = this.mockReserveBalances(new HashMap<String, BigDecimal>());
        BigDecimal expectedTotalLocked = this.mockLockedBalances(new HashMap<String, BigDecimal>());
        BigDecimal expectedCirculatingSupply = expectedTotalSupply.subtract(expectedTotalReserves).subtract(expectedTotalLocked);
        BigDecimal expectedMarketCap = expectedCirculatingSupply.multiply(MEED_USD_EXCHANGE_RATE);
        this.meedTokenMetricService.computeTokenMetrics();
        BigDecimal marketCap = this.meedTokenMetricService.getMarketCapitalization(null);
        Assertions.assertEquals((Object)expectedMarketCap, (Object)marketCap);
        BigDecimal marketCapEur = this.meedTokenMetricService.getMarketCapitalization(Currency.EUR);
        Assertions.assertEquals((Object)expectedMarketCap.multiply(USD_EUR_EXCHANGE_RATE), (Object)marketCapEur);
    }

    private BigDecimal mockReserveBalances(Map<String, BigDecimal> expectedReserveBalances) {
        BigDecimal valueBigDecimal;
        double value;
        BigDecimal totalReserves = new BigDecimal(0);
        for (String address : this.meedTokenMetricService.getReserveEthereumAddresses()) {
            value = Math.random() * 1000.0;
            valueBigDecimal = BigDecimal.valueOf(value);
            Mockito.when((Object)this.blockchainService.meedBalanceOfNoDecimals(address)).thenReturn((Object)valueBigDecimal);
            expectedReserveBalances.put(address.toLowerCase(), valueBigDecimal);
            totalReserves = totalReserves.add(valueBigDecimal);
        }
        for (String address : this.meedTokenMetricService.getReservePolygonAddresses()) {
            value = Math.random() * 1000.0;
            valueBigDecimal = BigDecimal.valueOf(value);
            Mockito.when((Object)this.blockchainService.meedBalanceOfOnPolygon(address)).thenReturn((Object)valueBigDecimal);
            expectedReserveBalances.put(address.toLowerCase(), valueBigDecimal);
            totalReserves = totalReserves.add(valueBigDecimal);
        }
        return totalReserves;
    }

    private BigDecimal mockLockedBalances(Map<String, BigDecimal> expectedLockedBalances) {
        BigDecimal valueBigDecimal;
        double value;
        BigDecimal totallocked = new BigDecimal(0);
        for (String address : this.meedTokenMetricService.getLockedEthereumAddresses()) {
            value = Math.random() * 1000.0;
            valueBigDecimal = BigDecimal.valueOf(value);
            Mockito.when((Object)this.blockchainService.meedBalanceOfNoDecimals(address)).thenReturn((Object)valueBigDecimal);
            expectedLockedBalances.put(address.toLowerCase(), valueBigDecimal);
            totallocked = totallocked.add(valueBigDecimal);
        }
        for (String address : this.meedTokenMetricService.getLockedPolygonAddresses()) {
            value = Math.random() * 1000.0;
            valueBigDecimal = BigDecimal.valueOf(value);
            Mockito.when((Object)this.blockchainService.meedBalanceOfOnPolygon(address)).thenReturn((Object)valueBigDecimal);
            expectedLockedBalances.put(address.toLowerCase(), valueBigDecimal);
            totallocked = totallocked.add(valueBigDecimal);
        }
        return totallocked;
    }
}

