/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.filter;

import io.meeds.dapp.web.filter.RequestDispatcherFilter;
import io.meeds.dapp.web.utils.EnvironmentService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={RequestDispatcherFilter.class, EnvironmentService.class})
@TestPropertySource(properties={"meeds.deed.hostEnvironment=production"})
class RequestDispatcherFilterTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher dispatcher;
    @Mock
    private FilterChain chain;
    private RequestDispatcherFilter dispatcherFilter;

    RequestDispatcherFilterTest() {
    }

    @BeforeEach
    void before() throws ServletException {
        this.dispatcherFilter = new RequestDispatcherFilter(){
            private static final long serialVersionUID = 4367082767921658504L;
        };
        Mockito.when((Object)this.request.getRequestDispatcher(ArgumentMatchers.anyString())).thenReturn((Object)this.dispatcher);
    }

    @Test
    void testGetNotFoundPage() throws Exception {
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://test/test"));
        Mockito.when((Object)this.request.getServletPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.request.getParameter("lang")).thenReturn((Object)"en");
        this.dispatcherFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setStatus(ArgumentMatchers.anyInt());
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).setHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Test
    void testGetStaticPage() throws Exception {
        String servletPath = "/tour";
        String lang = "en";
        String i18NContent = "metadata.tour.pageDescription=Test Label\nmetadata.tour.imageAlt=Image Alt\nmetadata.tour.twitterTitle=Twitter Title\nmetadata.tour.pageTitle=Page Title\n";
        String metadataContent = "#{metadata.tour.pageDescription}-${lang}";
        Mockito.when((Object)this.request.getRequestURL()).thenReturn((Object)new StringBuffer("http://test" + servletPath));
        Mockito.when((Object)this.request.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)this.request.getParameter("lang")).thenReturn((Object)lang);
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)servletContext);
        Mockito.when((Object)servletContext.getResourceAsStream("/static/i18n/messages_" + lang + ".properties")).thenReturn((Object)new ByteArrayInputStream(i18NContent.getBytes()));
        Mockito.when((Object)servletContext.getResourceAsStream("/WEB-INF/metadata" + servletPath + ".html")).thenReturn((Object)new ByteArrayInputStream(metadataContent.getBytes()));
        this.dispatcherFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).setAttribute("isStaticPath", (Object)true);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setContentType("text/html; charset=UTF-8");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setDateHeader("Last-Modified", RequestDispatcherFilter.LAST_MODIFIED);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("Cache-Control", "public,must-revalidate");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"etag"), (String)ArgumentMatchers.any());
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).setAttribute((String)ArgumentMatchers.eq((Object)"pageHeaderMetadatas"), ArgumentMatchers.argThat(contentObject -> {
            String content = (String)contentObject;
            Assertions.assertEquals((Object)metadataContent.replace("#{metadata.tour.pageDescription}", "Test Label").replace("${lang}", lang), (Object)content);
            return true;
        }));
        ((FilterChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        ((RequestDispatcher)Mockito.verify((Object)this.dispatcher, (VerificationMode)Mockito.times((int)1))).include((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

