/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.service;

import io.meeds.dapp.service.DeedMetadataService;
import io.meeds.deeds.common.constant.DisplayType;
import io.meeds.deeds.common.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.common.elasticsearch.storage.DeedMetadataRepository;
import io.meeds.deeds.common.model.DeedMetadataAttribute;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={DeedMetadataService.class})
@TestPropertySource(properties={"meeds.deed.metadatas.path=metadatas-test.json", "meeds.deed.contract.metadatas.path=deedCollection-test.json", "meeds.deed.metadata.serverBase=https://wom.meeds.io/dapp"})
class DeedMetadataServiceTest {
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private DeedMetadataRepository deedMetadataRepository;
    @Autowired
    private DeedMetadataService deedMetadataService;

    DeedMetadataServiceTest() {
    }

    @Test
    void testInit() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService);
        Assertions.assertNotNull((Object)this.deedMetadataService.getContractMetadata());
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 0));
    }

    @Test
    void testGetContractMetadata() throws Exception {
        DeedMetadata contractMetadata = this.deedMetadataService.getContractMetadata();
        Assertions.assertNotNull((Object)contractMetadata);
        Assertions.assertEquals((Object)"Meeds DAO", (Object)contractMetadata.getName());
        Assertions.assertEquals((Object)"Deed Collection", (Object)contractMetadata.getDescription());
        Assertions.assertEquals((Object)"https://meeds.io/investors", (Object)contractMetadata.getExternalLink());
        Assertions.assertEquals((Object)"https://wom.meeds.io/dapp/static/images/nft/deed-collection-avatar.png", (Object)contractMetadata.getImageUrl());
    }

    @Test
    void testGetDeedMetadataOfCard0() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(0, 4));
    }

    @Test
    void testGetDeedMetadataOfCard1() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(1, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(1, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(1, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(1, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(1, 4));
    }

    @Test
    void testGetDeedMetadataOfCard2() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(2, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(2, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(2, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(2, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(2, 4));
    }

    @Test
    void testGetDeedMetadataOfCard3() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(3, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(3, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(3, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(3, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(3, 4));
    }

    @Test
    void testGetDeedMetadataOfCard4() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(4, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(4, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(4, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(4, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(4, 4));
    }

    @Test
    void testGetDeedMetadataOfCard5() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(5, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(5, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(5, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(5, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(5, 4));
    }

    @Test
    void testGetDeedMetadataOfCard6() throws Exception {
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(6, 0));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(6, 1));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(6, 2));
        Assertions.assertNotNull((Object)this.deedMetadataService.getDeedMetadataOfCard(6, 3));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(6, 4));
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadataOfCard(7, 0));
    }

    @Test
    void testGetDeedMetadataOfCardContent() throws Exception {
        DeedMetadata metadata = this.deedMetadataService.getDeedMetadataOfCard(0, 0);
        Assertions.assertEquals((Object)"Tanit - Common", (Object)metadata.getName());
        Assertions.assertEquals((Object)"Deed NFT : Tanit - Common", (Object)metadata.getDescription());
        Assertions.assertEquals((Object)"#ffffff", (Object)metadata.getBackgroundColor());
        Assertions.assertEquals((Object)"https://wom.meeds.io/dapp/static/images/nft/tanit-common.png", (Object)metadata.getImageUrl());
        Assertions.assertNotNull((Object)metadata.getAttributes());
        Assertions.assertEquals((int)2, (int)metadata.getAttributes().size());
        DeedMetadataAttribute mintingPower = metadata.getAttributes().stream().filter(attr -> StringUtils.equals((CharSequence)"Minting Power", (CharSequence)attr.getTraitType())).findFirst().orElse(null);
        Assertions.assertNotNull((Object)mintingPower);
        Assertions.assertEquals((Object)DisplayType.BOOST_NUMBER, (Object)mintingPower.getDisplayType());
        Assertions.assertEquals((Object)1, (Object)mintingPower.getValue());
        Assertions.assertEquals((double)2.0, (Double)mintingPower.getMaxValue());
    }

    @Test
    void testGetDeedMetadataFromDB() throws Exception {
        long nftId = 1L;
        DeedMetadata metadata = new DeedMetadata();
        metadata.setNftId(nftId);
        Mockito.when((Object)this.deedMetadataRepository.findById((Object)nftId)).thenReturn(Optional.of(metadata));
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadata(Long.valueOf(nftId));
        Assertions.assertEquals((Object)metadata, (Object)deedMetadata);
    }

    @Test
    void testGetDeedMetadataFromBlockchain() throws Exception {
        long nftId = 2L;
        short cityIndex = 1;
        short cardType = 2;
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(ArgumentMatchers.anyLong())).then(invocation -> {
            Long argument = (Long)invocation.getArgument(0, Long.class);
            if (argument == nftId) {
                return cityIndex;
            }
            throw new ObjectNotFoundException();
        });
        Mockito.when((Object)this.blockchainService.getDeedCardType(ArgumentMatchers.anyLong())).then(invocation -> {
            Long argument = (Long)invocation.getArgument(0, Long.class);
            if (argument == nftId) {
                return cardType;
            }
            throw new ObjectNotFoundException();
        });
        Assertions.assertNull((Object)this.deedMetadataService.getDeedMetadata(Long.valueOf(1L)));
        DeedMetadata metadata = this.deedMetadataService.getDeedMetadata(Long.valueOf(nftId));
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((long)nftId, (long)metadata.getNftId());
        Assertions.assertEquals((Object)"Reshef - Rare", (Object)metadata.getName());
        Assertions.assertEquals((Object)"Deed NFT : Reshef - Rare", (Object)metadata.getDescription());
        Assertions.assertEquals((Object)"#ffffff", (Object)metadata.getBackgroundColor());
        Assertions.assertEquals((Object)"https://wom.meeds.io/dapp/static/images/nft/reshef-rare.png", (Object)metadata.getImageUrl());
        Assertions.assertNotNull((Object)metadata.getAttributes());
        Assertions.assertEquals((int)2, (int)metadata.getAttributes().size());
        DeedMetadataAttribute mintingPower = metadata.getAttributes().stream().filter(attr -> StringUtils.equals((CharSequence)"Minting Power", (CharSequence)attr.getTraitType())).findFirst().orElse(null);
        Assertions.assertNotNull((Object)mintingPower);
        Assertions.assertEquals((Object)DisplayType.BOOST_NUMBER, (Object)mintingPower.getDisplayType());
        Assertions.assertEquals((Object)1.3, (Object)mintingPower.getValue());
        Assertions.assertEquals((double)2.0, (Double)mintingPower.getMaxValue());
        DeedMetadataAttribute maxUsers = metadata.getAttributes().stream().filter(attr -> StringUtils.equals((CharSequence)"Max users", (CharSequence)attr.getTraitType())).findFirst().orElse(null);
        Assertions.assertNotNull((Object)maxUsers);
        Assertions.assertEquals((Object)DisplayType.NUMBER, (Object)maxUsers.getDisplayType());
        Assertions.assertEquals((Object)10000, (Object)maxUsers.getValue());
        Assertions.assertNull((Object)maxUsers.getMaxValue());
    }
}

