/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest.utils;

import io.meeds.dapp.web.rest.model.DeedMetadataPresentation;
import io.meeds.dapp.web.rest.model.DeedTenantPresentation;
import io.meeds.dapp.web.rest.model.HubWithReward;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.elasticsearch.model.DeedMetadata;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.model.DeedMetadataAttribute;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubReport;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;

public class EntityBuilder {
    private EntityBuilder() {
    }

    public static ResponseEntity<DeedTenantPresentation> getDeedTenantResponse(DeedTenant deedTenant) {
        if (deedTenant == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().body((Object)EntityBuilder.build(deedTenant));
    }

    public static ResponseEntity<DeedMetadataPresentation> getDeedMetadataResponse(DeedMetadata deedMetadata) {
        if (deedMetadata == null) {
            return ResponseEntity.notFound().build();
        }
        ResponseEntity.BodyBuilder response = ResponseEntity.ok();
        EntityBuilder.applyCache(response);
        EntityBuilder.allowOtherOrigins(response);
        return response.body((Object)EntityBuilder.build(deedMetadata));
    }

    public static DeedMetadataPresentation build(DeedMetadata deedMetadata) {
        if (deedMetadata == null) {
            return null;
        }
        HashSet<DeedMetadataAttribute> attributes = deedMetadata.getAttributes() == null ? new HashSet<DeedMetadataAttribute>() : new HashSet(deedMetadata.getAttributes());
        return new DeedMetadataPresentation(deedMetadata.getName(), deedMetadata.getDescription(), deedMetadata.getImageUrl(), deedMetadata.getBackgroundColor(), deedMetadata.getExternalUrl(), deedMetadata.getExternalLink(), deedMetadata.getSellerFeeBasisPoints(), deedMetadata.getFeeRecipient(), attributes);
    }

    public static DeedTenantPresentation build(DeedTenant deedTenant) {
        LocalDateTime date = deedTenant.getDate();
        long epochSecond = date == null ? 0L : date.toEpochSecond(ZoneOffset.UTC);
        return new DeedTenantPresentation(deedTenant.getNftId(), deedTenant.getManagerAddress(), Objects.requireNonNullElse(deedTenant.getTenantProvisioningStatus(), TenantProvisioningStatus.STOP_CONFIRMED), Objects.requireNonNullElse(deedTenant.getTenantStatus(), TenantStatus.UNDEPLOYED), epochSecond);
    }

    public static HubWithReward decorateHubWithReward(Hub hub, HubReportService hubReportService) {
        Page reports = hubReportService.getReportsByHub(hub.getAddress(), (Pageable)PageRequest.of((int)0, (int)3, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"sentDate"})));
        HubReport lastSentReport = reports.stream().findFirst().orElse(null);
        HubReport lastRewardedReport = reports.stream().filter(r -> hubReportService.computeEngagementScore(r.getReportId()) > 0.0).findFirst().orElse(null);
        return new HubWithReward(hub, lastSentReport == null ? 0L : lastSentReport.getActionsCount(), lastSentReport == null ? 0.0 : lastSentReport.getHubTopRewardedAmount(), lastRewardedReport == null ? 0.0 : lastRewardedReport.getEngagementScore(), lastRewardedReport != null);
    }

    private static void applyCache(ResponseEntity.BodyBuilder response) {
        ((ResponseEntity.BodyBuilder)response.cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.DAYS).cachePublic())).lastModified(ZonedDateTime.now());
    }

    private static void allowOtherOrigins(ResponseEntity.BodyBuilder response) {
        response.headers(headers -> {
            headers.set("Access-Control-Allow-Origin", "*");
            headers.addAll("Access-Control-Allow-Headers", Arrays.asList("Content-Type", "Range", "User-Agent", "X-Requested-With"));
            headers.addAll("Access-Control-Expose-Headers", Arrays.asList("Content-Range", "X-Chunked-Output", "X-Stream-Output"));
            headers.addAll("Access-Control-Allow-Methods", Arrays.asList("GET", "HEAD"));
        });
    }
}

