/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.UserProfileController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.model.UserProfileDTO;
import io.meeds.deeds.common.service.UserProfileService;
import jakarta.servlet.Filter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={UserProfileController.class, DeedAuthenticationProvider.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ContextConfiguration(classes={WebSecurityConfig.class})
class UserProfileControllerTest {
    private static final String TEST_PASSWORD = "testPassword";
    private static final String TEST_USER = "testUser";
    private static final String TEST_EMAIL = "email";
    @MockBean
    private UserProfileService userProfileService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    UserProfileControllerTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void testGetProfileEmailWhenNotAuthenticated() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/profile/email", (Object[])new Object[0]).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().is3xxRedirection());
    }

    @Test
    void testGetProfileEmailWhenAuthenticated() throws Exception {
        Mockito.when((Object)this.userProfileService.getUserProfile(TEST_USER)).thenReturn((Object)new UserProfileDTO(TEST_USER, TEST_EMAIL));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/profile/email", (Object[])new Object[0]).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(TEST_EMAIL));
    }

    private RequestPostProcessor testUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)TEST_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("USER")});
    }
}

