/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.HubController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.model.FileBinary;
import io.meeds.deeds.common.model.ManagedDeed;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.deeds.common.service.HubService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubUpdateRequest;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import io.meeds.wom.api.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartFile;
import org.web3j.crypto.Credentials;

@SpringBootTest(classes={HubController.class, DeedAuthenticationProvider.class, WebSecurityConfig.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
public class HubControllerTest {
    private static final String AVATAR_PATH = "/avatar";
    private static final String API_HUBS = "/api/hubs";
    private static final String HUB_ADDRESS_PARAM = "hubAddress";
    private static final String TOKEN = "token";
    private static final String RAW_MESSAGE = "rawMessage";
    private static final String SIGNED_MESSAGE = "signedMessage";
    @MockBean
    private HubService hubService;
    @MockBean
    private HubReportService reportService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;
    private Credentials hubCredentials = Credentials.create((String)"0x1da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private String hubAddress = this.hubCredentials.getAddress();
    private long deedId = 3L;
    private short city = 1;
    private short cardType = (short)2;
    private String deedOwnerAddress = "0x530417D6909834f9Ebfe5d98b649433B616Efb38";
    private Credentials deedManagerCredentials = Credentials.create((String)"0x3ba4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private String deedManagerAddress;
    private String hubOwnerAddress = this.deedManagerAddress = this.deedManagerCredentials.getAddress();
    private Map<String, String> name = Collections.singletonMap("en", "name");
    private Map<String, String> description = Collections.singletonMap("en", "description");
    private String url = "url";
    private String color = "#144523";
    private long usersCount = 56L;
    private String rewardsPeriodType = "WEEK";
    private double rewardsPerPeriod = 566.54;
    private boolean enabled = true;
    private double ownerClaimableAmount = 25.6;
    private double managerClaimableAmount = 12.9;
    private Instant createdDate = Instant.now().minusSeconds(16L);
    private Instant untilDate = Instant.now().plusSeconds(28L);
    private Instant joinDate = Instant.now().minusSeconds(10L);
    private Instant updatedDate = Instant.now();
    private String womAddress = "womAddress";
    private String uemAddress = "uemAddress";
    private long uemNetworkId = 80001L;

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void getHubs() throws Exception {
        Mockito.when((Object)this.hubService.getHubs(ArgumentMatchers.eq((long)0L), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(this.newHub())));
        Mockito.when((Object)this.reportService.getReportsByHub((String)ArgumentMatchers.eq((Object)this.hubAddress), (Pageable)ArgumentMatchers.any())).thenReturn((Object)Page.empty());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)API_HUBS, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    @WithAnonymousUser
    void getHubNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/" + this.hubAddress), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getHub() throws Exception {
        Mockito.when((Object)this.hubService.getHub(this.hubAddress, false)).thenReturn((Object)this.newHub());
        Mockito.when((Object)this.reportService.getReportsByHub((String)ArgumentMatchers.eq((Object)this.hubAddress), (Pageable)ArgumentMatchers.any())).thenReturn((Object)Page.empty());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/" + this.hubAddress), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedId", (Matcher)Matchers.is((Object)((int)this.deedId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.city", (Matcher)Matchers.is((Object)this.city))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)this.cardType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.address", (Matcher)Matchers.is((Object)this.hubAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is(this.name))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.description", (Matcher)Matchers.is(this.description))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.url", (Matcher)Matchers.is((Object)this.url))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.color", (Matcher)Matchers.is((Object)this.color))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubOwnerAddress", (Matcher)Matchers.is((Object)this.hubOwnerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedOwnerAddress", (Matcher)Matchers.is((Object)this.deedOwnerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedManagerAddress", (Matcher)Matchers.is((Object)this.deedManagerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.usersCount", (Matcher)Matchers.is((Object)((int)this.usersCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardsPeriodType", (Matcher)Matchers.is((Object)this.rewardsPeriodType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardsPerPeriod", (Matcher)Matchers.is((Object)this.rewardsPerPeriod))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.connected", (Matcher)Matchers.is((Object)this.enabled))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerClaimableAmount", (Matcher)Matchers.is((Object)this.ownerClaimableAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.managerClaimableAmount", (Matcher)Matchers.is((Object)this.managerClaimableAmount)));
    }

    @Test
    @WithAnonymousUser
    void getManagedDeeds() throws Exception {
        Mockito.when((Object)this.hubService.getManagedDeeds(this.deedManagerAddress)).thenReturn(Arrays.asList(new ManagedDeed()));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/managed-deeds/" + this.deedManagerAddress), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Object[])new Object[0]).isArray());
    }

    @Test
    @WithAnonymousUser
    void saveHubAvatarWhenObjectNotFoundException() throws Exception {
        ((HubService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.hubService)).saveHubAvatar((String)ArgumentMatchers.eq((Object)this.hubAddress), (String)ArgumentMatchers.eq((Object)SIGNED_MESSAGE), (String)ArgumentMatchers.eq((Object)RAW_MESSAGE), (String)ArgumentMatchers.eq((Object)TOKEN), (MultipartFile)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]).file("file", new byte[0]).param(HUB_ADDRESS_PARAM, new String[]{this.hubAddress}).param(SIGNED_MESSAGE, new String[]{SIGNED_MESSAGE}).param(RAW_MESSAGE, new String[]{RAW_MESSAGE}).param(TOKEN, new String[]{TOKEN}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void saveHubAvatarWhenWomException() throws Exception {
        ((HubService)Mockito.doThrow(WomException.class).when((Object)this.hubService)).saveHubAvatar((String)ArgumentMatchers.eq((Object)this.hubAddress), (String)ArgumentMatchers.eq((Object)SIGNED_MESSAGE), (String)ArgumentMatchers.eq((Object)RAW_MESSAGE), (String)ArgumentMatchers.eq((Object)TOKEN), (MultipartFile)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]).file("file", new byte[0]).param(HUB_ADDRESS_PARAM, new String[]{this.hubAddress}).param(SIGNED_MESSAGE, new String[]{SIGNED_MESSAGE}).param(RAW_MESSAGE, new String[]{RAW_MESSAGE}).param(TOKEN, new String[]{TOKEN}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void saveHubAvatarWhenIOException() throws Exception {
        ((HubService)Mockito.doThrow(IOException.class).when((Object)this.hubService)).saveHubAvatar((String)ArgumentMatchers.eq((Object)this.hubAddress), (String)ArgumentMatchers.eq((Object)SIGNED_MESSAGE), (String)ArgumentMatchers.eq((Object)RAW_MESSAGE), (String)ArgumentMatchers.eq((Object)TOKEN), (MultipartFile)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]).file("file", new byte[0]).param(HUB_ADDRESS_PARAM, new String[]{this.hubAddress}).param(SIGNED_MESSAGE, new String[]{SIGNED_MESSAGE}).param(RAW_MESSAGE, new String[]{RAW_MESSAGE}).param(TOKEN, new String[]{TOKEN}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void saveHubAvatar() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]).file("file", new byte[0]).param(HUB_ADDRESS_PARAM, new String[]{this.hubAddress}).param(SIGNED_MESSAGE, new String[]{SIGNED_MESSAGE}).param(RAW_MESSAGE, new String[]{RAW_MESSAGE}).param(TOKEN, new String[]{TOKEN}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((HubService)Mockito.verify((Object)this.hubService)).saveHubAvatar((String)ArgumentMatchers.eq((Object)this.hubAddress), (String)ArgumentMatchers.eq((Object)SIGNED_MESSAGE), (String)ArgumentMatchers.eq((Object)RAW_MESSAGE), (String)ArgumentMatchers.eq((Object)TOKEN), (MultipartFile)ArgumentMatchers.any());
    }

    @Test
    @WithAnonymousUser
    void getHubAvatarNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getHubAvatarNoCache() throws Exception {
        FileBinary file = (FileBinary)Mockito.mock(FileBinary.class);
        Mockito.when((Object)this.hubService.getHubAvatar(this.hubAddress)).thenReturn((Object)file);
        Mockito.when((Object)file.getBinary()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
        Mockito.when((Object)file.getUpdatedDate()).thenReturn((Object)this.updatedDate);
        Mockito.when((Object)file.getMimeType()).thenReturn((Object)"image/png");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().dateValue("last-modified", this.updatedDate.toEpochMilli())).andExpect(MockMvcResultMatchers.header().string("content-type", "image/png")).andExpect(MockMvcResultMatchers.header().string("cache-control", "no-store"));
    }

    @Test
    @WithAnonymousUser
    void getHubAvatarWithCache() throws Exception {
        FileBinary file = (FileBinary)Mockito.mock(FileBinary.class);
        Mockito.when((Object)this.hubService.getHubAvatar(this.hubAddress)).thenReturn((Object)file);
        Mockito.when((Object)file.getBinary()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
        Mockito.when((Object)file.getUpdatedDate()).thenReturn((Object)this.updatedDate);
        Mockito.when((Object)file.getMimeType()).thenReturn((Object)"image/png");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/" + this.hubAddress + AVATAR_PATH), (Object[])new Object[0]).param("v", new String[]{"lastUpdated"}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().dateValue("last-modified", this.updatedDate.toEpochMilli())).andExpect(MockMvcResultMatchers.header().string("content-type", "image/png")).andExpect(MockMvcResultMatchers.header().string("cache-control", "max-age=31536000, public"));
    }

    @Test
    @WithAnonymousUser
    void connectToWomWhenWomRequestException() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenThrow(WomRequestException.class);
        WomConnectionRequest womConnectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)womConnectionRequest)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void connectToWomWhenWomParsingException() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenThrow(WomParsingException.class);
        WomConnectionRequest womConnectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)womConnectionRequest)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void connectToWomWhenWomAuthorizationException() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenThrow(WomAuthorizationException.class);
        WomConnectionRequest womConnectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)womConnectionRequest)));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    @WithAnonymousUser
    void connectToWomWhenWomException() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenThrow(WomException.class);
        WomConnectionRequest womConnectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)womConnectionRequest)));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void connectToWomWhenException() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenThrow(RuntimeException.class);
        WomConnectionRequest womConnectionRequest = new WomConnectionRequest();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)womConnectionRequest)));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void connectToWom() throws Exception {
        Mockito.when((Object)this.hubService.connectToWom((WomConnectionRequest)ArgumentMatchers.any())).thenReturn((Object)new WomConnectionResponse(this.deedId, this.hubAddress, this.womAddress, this.uemAddress, this.uemNetworkId));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomConnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedId", (Matcher)Matchers.is((Object)((int)this.deedId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubAddress", (Matcher)Matchers.is((Object)this.hubAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.womAddress", (Matcher)Matchers.is((Object)this.womAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uemAddress", (Matcher)Matchers.is((Object)this.uemAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.networkId", (Matcher)Matchers.is((Object)((int)this.uemNetworkId))));
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWomWhenWomRequestException() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenThrow(WomRequestException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWomWhenWomParsingException() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenThrow(WomParsingException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWomWhenWomAuthorizationException() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenThrow(WomAuthorizationException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWomWhenWomException() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenThrow(WomException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWomWhenException() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenThrow(RuntimeException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void disconnectFromWom() throws Exception {
        Mockito.when((Object)this.hubService.disconnectFromWom((WomDisconnectionRequest)ArgumentMatchers.any())).thenReturn((Object)this.womAddress);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new WomDisconnectionRequest())));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(this.womAddress));
    }

    @Test
    @WithAnonymousUser
    void updateHubWhenWomRequestException() throws Exception {
        ((HubService)Mockito.doThrow(WomRequestException.class).when((Object)this.hubService)).updateHub((HubUpdateRequest)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void updateHubWhenWomParsingException() throws Exception {
        ((HubService)Mockito.doThrow(WomParsingException.class).when((Object)this.hubService)).updateHub((HubUpdateRequest)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void updateHubWhenWomAuthorizationException() throws Exception {
        ((HubService)Mockito.doThrow(WomAuthorizationException.class).when((Object)this.hubService)).updateHub((HubUpdateRequest)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    @WithAnonymousUser
    void updateHubWhenWomException() throws Exception {
        ((HubService)Mockito.doThrow(WomException.class).when((Object)this.hubService)).updateHub((HubUpdateRequest)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void updateHubWhenException() throws Exception {
        ((HubService)Mockito.doThrow(RuntimeException.class).when((Object)this.hubService)).updateHub((HubUpdateRequest)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void updateHub() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)API_HUBS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubUpdateRequest())));
        response.andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    @WithAnonymousUser
    void getHubByNftIdNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/byNftId/" + this.deedId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getHubByNftId() throws Exception {
        Mockito.when((Object)this.hubService.getHub(Long.valueOf(this.deedId))).thenReturn((Object)this.newHub());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hubs/byNftId/" + this.deedId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedId", (Matcher)Matchers.is((Object)((int)this.deedId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.city", (Matcher)Matchers.is((Object)this.city))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)this.cardType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.address", (Matcher)Matchers.is((Object)this.hubAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is(this.name))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.description", (Matcher)Matchers.is(this.description))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.url", (Matcher)Matchers.is((Object)this.url))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.color", (Matcher)Matchers.is((Object)this.color))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubOwnerAddress", (Matcher)Matchers.is((Object)this.hubOwnerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedOwnerAddress", (Matcher)Matchers.is((Object)this.deedOwnerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedManagerAddress", (Matcher)Matchers.is((Object)this.deedManagerAddress.toLowerCase()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.usersCount", (Matcher)Matchers.is((Object)((int)this.usersCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardsPeriodType", (Matcher)Matchers.is((Object)this.rewardsPeriodType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardsPerPeriod", (Matcher)Matchers.is((Object)this.rewardsPerPeriod))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.connected", (Matcher)Matchers.is((Object)this.enabled))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerClaimableAmount", (Matcher)Matchers.is((Object)this.ownerClaimableAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.managerClaimableAmount", (Matcher)Matchers.is((Object)this.managerClaimableAmount)));
    }

    private Hub newHub() {
        return new Hub(this.deedId, this.city, this.cardType, this.hubAddress, this.name, this.description, this.url, this.color, this.hubOwnerAddress, this.deedOwnerAddress, this.deedManagerAddress, this.createdDate, this.untilDate, this.joinDate, this.updatedDate, this.usersCount, this.rewardsPeriodType, this.rewardsPerPeriod, this.enabled, this.ownerClaimableAmount, this.managerClaimableAmount);
    }
}

