/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.dapp.web.rest.model.DeedTenantPresentation;
import io.meeds.dapp.web.rest.utils.EntityBuilder;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.constant.UnauthorizedOperationException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.service.TenantService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import java.security.Principal;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/tenants"})
public class TenantController {
    private static final Logger LOG = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private TenantService tenantService;

    @GetMapping(produces={"application/json"})
    public List<DeedTenantPresentation> getTenants(Principal principal, @RequestParam(name="address", required=false) String walletAddress) {
        if (StringUtils.isBlank((CharSequence)walletAddress)) {
            if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            walletAddress = principal.getName();
        }
        List deedTenants = this.tenantService.getDeedTenants(walletAddress);
        return deedTenants.stream().map(EntityBuilder::build).toList();
    }

    @GetMapping(value={"/{nftId}"})
    public ResponseEntity<DeedTenantPresentation> getDeedTenant(Principal principal, @RequestHeader(name="X-REFRESH", required=false) boolean refreshFromBlockchain, @PathVariable(name="nftId") Long nftId, @RequestParam(name="address", required=false) String walletAddress) {
        if (StringUtils.isBlank((CharSequence)walletAddress)) {
            if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            walletAddress = principal.getName();
        }
        try {
            DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(walletAddress, nftId, refreshFromBlockchain);
            return EntityBuilder.getDeedTenantResponse(deedTenant);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping(value={"/{nftId}/startDate"})
    public ResponseEntity<String> getDeedTenantStartTime(@PathVariable(name="nftId") Long nftId) {
        DeedTenant deedTenant = this.tenantService.getDeedTenant(nftId.longValue());
        if (deedTenant == null || deedTenant.getDate() == null || deedTenant.getTenantProvisioningStatus() == null || deedTenant.getTenantProvisioningStatus().isStop() || deedTenant.getTenantStatus() != TenantStatus.DEPLOYED) {
            return ResponseEntity.ok((Object)"");
        }
        return ResponseEntity.ok((Object)String.valueOf(deedTenant.getDate().toEpochSecond(ZoneOffset.UTC)));
    }

    @PostMapping(value={"/{nftId}"})
    @Secured(value={"USER"})
    public void startTenant(@PathVariable(name="nftId") long nftId, @RequestParam(name="email", required=false) String email, @RequestParam(name="transactionHash", required=true) String transactionHash, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.startTenant(walletAddress, transactionHash, nftId, email);
        }
        catch (ObjectNotFoundException e) {
            this.throwNftNotExistsError();
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to send start tenant query for Deed with id {}", new Object[]{walletAddress, nftId, e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @DeleteMapping(value={"/{nftId}"})
    @Secured(value={"USER"})
    public void stopTenant(@PathVariable(name="nftId") long nftId, @RequestParam(name="transactionHash", required=true) String transactionHash, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.stopTenant(walletAddress, transactionHash, nftId);
        }
        catch (ObjectNotFoundException e) {
            this.throwNftNotExistsError();
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to send stop tenant query for Deed with id {}", new Object[]{walletAddress, nftId, e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @PatchMapping(path={"/{nftId}"})
    @Secured(value={"USER"})
    public void updateEmail(@PathVariable(name="nftId") long nftId, @RequestParam(name="email", required=true) String email, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.saveEmail(walletAddress, nftId, email);
        }
        catch (ObjectNotFoundException e) {
            this.throwNftNotExistsError();
        }
        catch (UnauthorizedOperationException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    private void throwNftNotExistsError() {
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "NFT doesn't exist");
    }
}

