/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning;

import io.meeds.tenant.provisioning.RedisConfigurationProperties;
import java.util.EventListener;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.repository.configuration.EnableRedisRepositories;
import redis.embedded.RedisServer;

@SpringBootApplication(scanBasePackages={"io.meeds.tenant.provisioning"})
@EnableRedisRepositories
@EnableConfigurationProperties(value={RedisConfigurationProperties.class})
public class RedisServerApplication
extends SpringBootServletInitializer {
    private RedisServer redisServer;

    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.addListener((EventListener)new /* Unavailable Anonymous Inner Class!! */);
        System.setProperty("org.springframework.boot.logging.LoggingSystem", "none");
        super.onStartup(servletContext);
    }

    @Bean
    public RedisServer redisServer(RedisConfigurationProperties redisProperties) {
        if (redisProperties.isEnabled()) {
            this.redisServer = new RedisServer(redisProperties.getPort());
            this.redisServer.start();
            return this.redisServer;
        }
        return null;
    }

    @PreDestroy
    public void stopServer() {
        if (this.redisServer != null) {
            this.redisServer.stop();
            this.redisServer = null;
        }
    }
}

