/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.listerner.model.EmailSendingCommand;
import io.meeds.tenant.provisioning.service.DeedEmailService;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailCommandListener
implements EventListener<EmailSendingCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(EmailCommandListener.class);
    public static final String LISTENER_NAME = "EmailCommandListener";
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("deed.event.sendEmailTemplateCommand");
    @Autowired
    private DeedEmailService deedEmailService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, EmailSendingCommand emailCommand) {
        try {
            this.deedEmailService.sendEmail(emailCommand);
        }
        catch (Exception e) {
            LOG.warn("Error sending automatic mail with detail {}", (Object)emailCommand, (Object)e);
        }
    }
}

