/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.model.UserProfileDTO;
import io.meeds.deeds.service.UserProfileService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TenantStartCommandCreatedListener
implements EventListener<DeedTenant> {
    public static final String LISTENER_NAME = "TenantStartCommandCreatedListener";
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("deed.event.tenantStart", "deed.event.tenantEmailUpdated");
    @Autowired
    private UserProfileService userProfileService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenant deedTenant) {
        if (StringUtils.isNotBlank((CharSequence)deedTenant.getManagerEmail())) {
            UserProfileDTO userProfileDTO = new UserProfileDTO(deedTenant.getManagerAddress(), deedTenant.getManagerEmail());
            this.userProfileService.saveUserProfile(userProfileDTO);
        }
    }
}

