/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.scheduling.task;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProvisioningBlockchainTransactionCheckTask {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisioningBlockchainTransactionCheckTask.class);
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private BlockchainService blockchainService;

    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.MINUTES, initialDelay=3L)
    public synchronized void checkPendingTenants() {
        List<DeedTenant> pendingDeedTenants = this.tenantProvisioningService.getPendingTransactions();
        int pendingDeedTenantsSize = pendingDeedTenants.size();
        if (pendingDeedTenantsSize == 0) {
            return;
        }
        LOG.info("Check {} pending transactions for Deed Tenant Provisioning.", (Object)pendingDeedTenantsSize);
        pendingDeedTenants.forEach(deedTenant -> {
            String transactionHash = null;
            try {
                long nftId = deedTenant.getNftId();
                if (StringUtils.isNotBlank((CharSequence)deedTenant.getStartupTransactionHash())) {
                    transactionHash = deedTenant.getStartupTransactionHash();
                    LOG.info("Check transaction {} status of Deed Tenant Provisioning (Deploy) with id {}.", (Object)transactionHash, (Object)nftId);
                    this.sendCommandFromTransaction((DeedTenant)deedTenant, transactionHash, nftId, true);
                } else if (StringUtils.isNotBlank((CharSequence)deedTenant.getShutdownTransactionHash())) {
                    transactionHash = deedTenant.getShutdownTransactionHash();
                    LOG.info("Check transaction {} status of Deed Tenant Provisioning (Undeploy) with id {}.", (Object)transactionHash, (Object)nftId);
                    this.sendCommandFromTransaction((DeedTenant)deedTenant, transactionHash, nftId, false);
                }
            }
            catch (Exception e) {
                LOG.warn("Can't check Provisioning status of transaction {}", transactionHash, (Object)e);
            }
        });
    }

    private void sendCommandFromTransaction(DeedTenant deedTenant, String transactionHash, long nftId, boolean start) throws ObjectNotFoundException {
        if (this.tenantProvisioningService.isTransactionAlreadyConfirmed(transactionHash, nftId)) {
            LOG.info("The mined transaction [{}] for nftId='{}' is already confirmed with a created [TASK]. Ignore adding a new task for it.", (Object)transactionHash, (Object)nftId);
        } else {
            this.checkTransactionAndSendProvisioningCommand(deedTenant, transactionHash, start);
        }
    }

    private void checkTransactionAndSendProvisioningCommand(DeedTenant deedTenant, String transactionHash, boolean start) throws ObjectNotFoundException {
        if (this.blockchainService.isTransactionMined(transactionHash)) {
            boolean transactionConfirmed = this.blockchainService.isTransactionConfirmed(transactionHash);
            LOG.info("Deed Tenant with id {} Transaction Provisioning mined. Status = {}", (Object)deedTenant.getNftId(), (Object)(transactionConfirmed ? "SUCCESS" : "FAIL"));
            if (transactionConfirmed) {
                if (start) {
                    this.tenantProvisioningService.startTenant(deedTenant.getNftId(), transactionHash, true);
                } else {
                    this.tenantProvisioningService.stopTenant(deedTenant.getNftId(), transactionHash, true);
                }
            } else {
                this.tenantProvisioningService.cancelTenantProvisioning(deedTenant.getNftId(), transactionHash);
            }
        } else {
            LOG.info("Deed Tenant with id {} Transaction Provisioning always in progress", (Object)deedTenant.getNftId());
        }
    }
}

