/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.service;

import io.meeds.deeds.blockchain.BlockchainConfigurationProperties;
import io.meeds.deeds.constant.DeedCard;
import io.meeds.deeds.constant.DeedCity;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.tenant.provisioning.TenantProvisioningConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskIntegrationService {
    public static final String TASK_ID_PROP_NAME = "taskId";
    public static final String CURRENT_TASK_ID_PROP_NAME = "currentTaskId";
    public static final String TASK_IDS_PROP_NAME = "taskIds";
    public static final String SPACES_PARENT_GROUP = "/spaces/";
    public static final String TASK_ID_SEPARATOR = ":";
    private static final Logger LOG = LoggerFactory.getLogger(TaskIntegrationService.class);
    @Autowired
    private TenantProvisioningConfiguration provisioningConfiguration;
    @Autowired
    private BlockchainConfigurationProperties blockchainProperties;
    private ProjectService taskProjectService;
    private TaskService taskService;
    private LabelService taskLabelService;
    private CommentService taskCommentService;
    private SpaceService spaceService;
    private ProjectDto project;
    private StatusDto taskPendingStatus;
    private StatusDto taskConfirmedStatus;
    private LabelDto transactionInProgressLabel;
    private LabelDto transactionConfirmedLabel;
    private LabelDto transactionErrorLabel;
    private LabelDto transactionConflictLabel;
    private Identity userIdentity;
    private PortalContainer container;
    private String etherscanPrefix;
    private boolean enabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTask(DeedTenant deedTenant, String transactionHash, boolean start, boolean confirmed) {
        this.initTaskServices();
        if (!this.enabled) {
            return false;
        }
        ConversationState currentConversationState = this.setCurrentConversationState();
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        TaskDto taskDto = null;
        try {
            taskDto = this.getTask(deedTenant, transactionHash, true);
            if (!confirmed && taskDto != null) {
                boolean bl = false;
                return bl;
            }
            long previousTaskId = this.getCurrentTaskId(deedTenant);
            StatusDto taskStatus = this.getTaskStatus(confirmed);
            if (taskDto == null) {
                taskDto = new TaskDto();
                taskDto.setStatus(taskStatus);
                taskDto.setPriority(confirmed ? Priority.HIGH : Priority.LOW);
                taskDto.setRank(1);
                taskDto.setCreatedBy(this.provisioningConfiguration.getTaskUsername());
                taskDto.setWatcher(this.getProjectManagers(this.project.getId()));
                taskDto.setDescription(this.buildDescription(deedTenant, transactionHash));
                taskDto.setTitle(this.buildTitle(deedTenant, start, confirmed, false));
                taskDto.setStartDate(new Date());
                taskDto = this.taskService.createTask(taskDto);
                this.adTaskLabel(taskDto, start, confirmed);
            } else {
                if (taskDto.getStatus() == null || this.taskPendingStatus.getId().equals(taskDto.getStatus().getId())) {
                    taskDto.setStatus(taskStatus);
                }
                taskDto.setTitle(this.buildTitle(deedTenant, start, confirmed, false));
                taskDto.setPriority(Priority.HIGH);
                taskDto = this.taskService.updateTask(taskDto);
                this.adTaskLabel(taskDto, start, confirmed);
            }
            long taskId = taskDto.getId();
            if (previousTaskId > 0L && taskId != previousTaskId) {
                this.cancelPreviousTask(previousTaskId, taskId, transactionHash);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.setTaskInformation(deedTenant, taskDto, start, confirmed, transactionHash);
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(DeedTenant deedTenant, String transactionHash) {
        this.initTaskServices();
        if (!this.enabled) {
            return false;
        }
        ConversationState currentConversationState = this.setCurrentConversationState();
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            TaskDto task = this.getTask(deedTenant, transactionHash);
            if (task == null) {
                boolean bl = false;
                return bl;
            }
            boolean isStartupCommand = StringUtils.equalsIgnoreCase((CharSequence)transactionHash, (CharSequence)deedTenant.getStartupTransactionHash());
            boolean isShutdownCommand = StringUtils.equalsIgnoreCase((CharSequence)transactionHash, (CharSequence)deedTenant.getShutdownTransactionHash());
            if (!isStartupCommand || !isShutdownCommand) {
                LOG.warn("Transaction {} isn't found in DEED {} as startup neither shutdown commands. Mark task {} as canceled", new Object[]{transactionHash, deedTenant.getNftId(), task.getId()});
                this.addComment(task, "Transaction not marked as last tracked transaction, thus it has been marked as canceled. Please verify other duplicated tasks for this DEED.");
                this.addTaskLabel(task, this.transactionConflictLabel);
            } else {
                this.addComment(task, "Tenant transaction error - Cancelled");
                this.addTaskLabel(task, this.transactionErrorLabel);
            }
            this.removeTaskLabel(task, this.transactionInProgressLabel);
            if (!task.isCompleted()) {
                task.setCompleted(true);
                task.setPriority(Priority.NORMAL);
                task.setTitle(this.buildTitle(deedTenant, isStartupCommand, true, true));
                task = this.taskService.updateTask(task);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Error while canceling Provisioning Task for DEED {}", (Object)deedTenant, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    public Set<String> getProjectManagers() {
        this.initTaskServices();
        if (!this.enabled) {
            return Collections.emptySet();
        }
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Set<String> set = this.getProjectManagers(this.project.getId());
            return set;
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTaskServices() {
        if (this.project != null) {
            return;
        }
        this.container = PortalContainer.getInstance();
        this.taskProjectService = (ProjectService)this.container.getComponentInstanceOfType(ProjectService.class);
        if (this.taskProjectService == null) {
            this.enabled = false;
            return;
        }
        this.taskService = (TaskService)this.container.getComponentInstanceOfType(TaskService.class);
        this.taskLabelService = (LabelService)this.container.getComponentInstanceOfType(LabelService.class);
        this.taskCommentService = (CommentService)this.container.getComponentInstanceOfType(CommentService.class);
        this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        StatusService taskStatusService = (StatusService)this.container.getComponentInstanceOfType(StatusService.class);
        Authenticator authenticator = (Authenticator)this.container.getComponentInstanceOfType(Authenticator.class);
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String username = this.provisioningConfiguration.getTaskUsername();
            long taskProjectId = this.provisioningConfiguration.getTaskProjectId();
            this.userIdentity = authenticator.createIdentity(username);
            if (this.userIdentity == null) {
                throw new IllegalStateException("User with name " + username + " not found");
            }
            this.project = this.taskProjectService.getProject(Long.valueOf(taskProjectId));
            if (this.project == null) {
                throw new IllegalStateException("Project with id " + taskProjectId + " not found");
            }
            List statuses = taskStatusService.getStatuses(taskProjectId);
            this.taskPendingStatus = (StatusDto)statuses.get(this.provisioningConfiguration.getTaskStatusPendingIndex());
            this.taskConfirmedStatus = (StatusDto)statuses.get(this.provisioningConfiguration.getTaskStatusConfirmedIndex());
            this.transactionInProgressLabel = this.getOrCreateLabel(this.provisioningConfiguration.getTransactionInProgressLabel(), "green");
            this.transactionConfirmedLabel = this.getOrCreateLabel(this.provisioningConfiguration.getTransactionConfirmedLabel(), "red");
            this.transactionErrorLabel = this.getOrCreateLabel(this.provisioningConfiguration.getTransactionErrorLabel(), "orange");
            this.transactionConflictLabel = this.getOrCreateLabel(this.provisioningConfiguration.getTransactionConflictLabel(), "red");
        }
        catch (Exception e) {
            this.project = null;
            LOG.warn("Error getting Tasks labels", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
        }
    }

    private void setTaskInformation(DeedTenant deedTenant, TaskDto taskDto, boolean start, boolean confirmed, String transactionHash) {
        if (taskDto != null && taskDto.getId() > 0L) {
            this.setDeedProvisioningTaskId(deedTenant, transactionHash, taskDto.getId());
            if (start) {
                if (confirmed) {
                    this.addComment(taskDto, "Deploy Tenant transaction validated");
                } else {
                    this.addComment(taskDto, "Deploy Tenant transaction in progress");
                }
            } else if (confirmed) {
                this.addComment(taskDto, "Undeploy Tenant transaction validated");
            } else {
                this.addComment(taskDto, "Undeploy Tenant transaction in progress");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDto getTask(DeedTenant deedTenant, String transactionHash) throws EntityNotFoundException {
        if (!this.enabled) {
            return null;
        }
        ConversationState currentConversationState = this.setCurrentConversationState();
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String[] taskIdParts;
            String taskId;
            if (deedTenant.getProperties() != null && StringUtils.isNotBlank((CharSequence)(taskId = (String)deedTenant.getProperties().get(TASK_ID_PROP_NAME))) && StringUtils.equalsIgnoreCase((CharSequence)(taskIdParts = StringUtils.split((String)taskId, (String)TASK_ID_SEPARATOR))[0], (CharSequence)transactionHash)) {
                long id = Long.parseLong(taskIdParts[1]);
                TaskDto taskDto = this.taskService.getTask(id);
                return taskDto;
            }
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommentDto addComment(TaskDto taskDto, String message) {
        ConversationState currentConversationState = this.setCurrentConversationState();
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String managersMention = this.getProjectManagersMention();
            CommentDto commentDto = this.taskCommentService.addComment(taskDto, this.provisioningConfiguration.getTaskUsername(), message + managersMention);
            return commentDto;
        }
        catch (Exception e) {
            LOG.warn("Error creating comment on task {}", (Object)taskDto.getId(), (Object)e);
            CommentDto commentDto = null;
            return commentDto;
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adTaskLabel(TaskDto task, boolean start, boolean confirmed) {
        ConversationState currentConversationState = this.setCurrentConversationState();
        ExoContainer currentExoContainer = this.setCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            if (confirmed) {
                this.addTaskLabel(task, this.transactionConfirmedLabel);
                this.removeTaskLabel(task, this.transactionInProgressLabel);
            } else {
                this.addTaskLabel(task, this.transactionInProgressLabel);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while adding Label to Task", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            if (currentExoContainer instanceof RootContainer) {
                ExoContainerContext.setCurrentContainer(null);
            }
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskLabel(TaskDto task, LabelDto label) {
        if (label != null) {
            ConversationState currentConversationState = this.setCurrentConversationState();
            ExoContainer currentExoContainer = this.setCurrentContainer();
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                List labels = this.taskLabelService.findLabelsByTask(task, label.getProject().getId(), this.userIdentity, 0, -1);
                if (labels.stream().noneMatch(labelTmp -> labelTmp.getId() == label.getId())) {
                    try {
                        this.taskLabelService.addTaskToLabel(task, Long.valueOf(label.getId()));
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to add label {} to task {}. Ignore deleting it.", new Object[]{label.getName(), task.getId(), e});
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
                if (currentExoContainer instanceof RootContainer) {
                    ExoContainerContext.setCurrentContainer(null);
                }
                ConversationState.setCurrent((ConversationState)currentConversationState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskLabel(TaskDto task, LabelDto label) {
        if (label != null) {
            ConversationState currentConversationState = this.setCurrentConversationState();
            ExoContainer currentExoContainer = this.setCurrentContainer();
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                List labels = this.taskLabelService.findLabelsByTask(task, label.getProject().getId(), this.userIdentity, 0, -1);
                if (labels.stream().anyMatch(labelTmp -> labelTmp.getId() == label.getId())) {
                    try {
                        this.taskLabelService.removeTaskFromLabel(task, Long.valueOf(label.getId()));
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to removing label {} from task {}. Ignore deleting it.", new Object[]{label.getName(), task.getId(), e});
                    }
                }
            }
            finally {
                RequestLifeCycle.end();
                if (currentExoContainer instanceof RootContainer) {
                    ExoContainerContext.setCurrentContainer(null);
                }
                ConversationState.setCurrent((ConversationState)currentConversationState);
            }
        }
    }

    private void setDeedProvisioningTaskId(DeedTenant deedTenant, String transactionHash, long taskId) {
        if (deedTenant.getProperties() == null) {
            deedTenant.setProperties(new HashMap());
        }
        deedTenant.getProperties().put(TASK_ID_PROP_NAME, this.computeTaskIdValue(taskId, transactionHash));
        deedTenant.getProperties().put(CURRENT_TASK_ID_PROP_NAME, String.valueOf(taskId));
        String oldTaskIds = (String)deedTenant.getProperties().get(TASK_IDS_PROP_NAME);
        if (StringUtils.isBlank((CharSequence)oldTaskIds)) {
            deedTenant.getProperties().put(TASK_IDS_PROP_NAME, String.valueOf(taskId));
        } else {
            HashSet<String> taskIdsSet = new HashSet<String>(Arrays.asList(oldTaskIds.split(",")));
            taskIdsSet.add(String.valueOf(taskId));
            deedTenant.getProperties().put(TASK_IDS_PROP_NAME, StringUtils.join(taskIdsSet, (String)","));
        }
    }

    private long getCurrentTaskId(DeedTenant deedTenant) {
        if (deedTenant != null && deedTenant.getProperties() != null && deedTenant.getProperties().containsKey(CURRENT_TASK_ID_PROP_NAME)) {
            String taskId = (String)deedTenant.getProperties().get(CURRENT_TASK_ID_PROP_NAME);
            return Long.parseLong(taskId);
        }
        return 0L;
    }

    private String computeTaskIdValue(long taskId, String transactionHash) {
        return transactionHash + TASK_ID_SEPARATOR + taskId;
    }

    private StatusDto getTaskStatus(boolean confirmed) {
        return confirmed ? this.taskConfirmedStatus : this.taskPendingStatus;
    }

    private TaskDto getTask(DeedTenant deedTenant, String transactionHash, boolean confirmed) {
        TaskDto taskDto = null;
        try {
            if (confirmed) {
                taskDto = this.getTask(deedTenant, transactionHash);
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving previously created task, create new one", (Throwable)e);
        }
        return taskDto;
    }

    private String buildTitle(DeedTenant deedTenant, boolean start, boolean confirmed, boolean error) {
        long nftId = deedTenant.getNftId();
        String status = error ? "[Error]" : (confirmed ? "[Confirmed]" : "[ComingSoon]");
        String command = start ? "Deploy" : "Undeploy";
        return "[DEED] " + status + " " + command + " DEED #" + nftId + " Tenant";
    }

    private String buildDescription(DeedTenant deedTenant, String transactionHash) {
        DeedCity deedCity = DeedCity.values()[deedTenant.getCityIndex()];
        DeedCard deedCard = DeedCard.values()[deedTenant.getCardType()];
        long nftId = deedTenant.getNftId();
        StringBuilder message = new StringBuilder();
        message.append("<p>").append("URL: ").append("https://").append(deedCity.name().toLowerCase()).append("-").append(nftId).append(".").append(this.provisioningConfiguration.getUrlSuffix()).append("</p>");
        message.append("<p>").append("Transaction: ").append(this.getEtherscanPrefix()).append("/tx/").append(transactionHash).append("</p>");
        message.append("<p>").append("NFT ID: ").append(this.getEtherscanPrefix()).append("/token/").append(this.blockchainProperties.getDeedAddress()).append("?a=").append(nftId).append("</p>");
        message.append("<p>").append("City Name: ").append(deedCity.name()).append("</p>");
        message.append("<p>").append("DEED Type: ").append(deedCard.name()).append("</p>");
        if (StringUtils.isNotBlank((CharSequence)deedTenant.getManagerEmail())) {
            message.append("<p>").append("Contact Email: ").append(deedTenant.getManagerEmail()).append("</p>");
        }
        if (StringUtils.isNotBlank((CharSequence)deedTenant.getManagerAddress())) {
            message.append("<p>").append("Owner: ").append(this.getEtherscanPrefix()).append("/address/").append(deedTenant.getManagerAddress()).append("</p>");
        }
        return message.toString();
    }

    private String getEtherscanPrefix() {
        if (StringUtils.isBlank((CharSequence)this.etherscanPrefix)) {
            this.etherscanPrefix = StringUtils.trim((String)this.provisioningConfiguration.getEtherscanPrefix());
            if (this.etherscanPrefix.endsWith("/")) {
                this.etherscanPrefix = this.etherscanPrefix.substring(0, this.etherscanPrefix.length() - 1);
            }
        }
        return this.etherscanPrefix;
    }

    private LabelDto getOrCreateLabel(String transactionLabel, String color) {
        String username = this.provisioningConfiguration.getTaskUsername();
        Long taskProjectId = this.provisioningConfiguration.getTaskProjectId();
        List labels = this.taskLabelService.findLabelsByProject(taskProjectId.longValue(), this.userIdentity, 0, -1);
        return labels.stream().filter(label -> StringUtils.equals((CharSequence)transactionLabel, (CharSequence)label.getName())).findFirst().orElseGet(() -> {
            LabelDto labelDto = new LabelDto();
            labelDto.setName(transactionLabel);
            labelDto.setCanEdit(true);
            labelDto.setProject(this.project);
            labelDto.setUsername(username);
            labelDto.setColor(color);
            return this.taskLabelService.createLabel(labelDto);
        });
    }

    private String getProjectManagersMention() {
        Set<String> projectUserManagers = this.getProjectManagers(this.project.getId());
        return projectUserManagers.stream().reduce("", (result, manager) -> {
            result = (String)result + " @" + manager;
            return result;
        });
    }

    private Set<String> getProjectManagers(long projectId) {
        Set managers = this.taskProjectService.getManager(projectId);
        if (managers != null) {
            return managers.stream().flatMap(manager -> {
                if (StringUtils.contains((CharSequence)manager, (CharSequence)SPACES_PARENT_GROUP)) {
                    List<String> spaceManagers = this.getSpaceManagers((String)manager);
                    return Stream.of(spaceManagers.toArray(new String[0]));
                }
                if (!StringUtils.contains((CharSequence)manager, (CharSequence)"/")) {
                    return Stream.of(manager);
                }
                return Stream.empty();
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private List<String> getSpaceManagers(String spaceGroupId) {
        Space space;
        if (StringUtils.contains((CharSequence)spaceGroupId, (CharSequence)TASK_ID_SEPARATOR)) {
            spaceGroupId = spaceGroupId.split(TASK_ID_SEPARATOR)[1];
        }
        if ((space = this.spaceService.getSpaceByGroupId(spaceGroupId)) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(space.getManagers());
    }

    private ConversationState setCurrentConversationState() {
        ConversationState currentConversationState = ConversationState.getCurrent();
        if (currentConversationState == null) {
            ConversationState.setCurrent((ConversationState)new ConversationState(this.userIdentity));
        }
        return currentConversationState;
    }

    private ExoContainer setCurrentContainer() {
        ExoContainer currentExoContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        return currentExoContainer;
    }

    private void cancelPreviousTask(long previousTaskId, long newTaskId, String transactionHash) {
        try {
            TaskDto deprecatedTaskToCancel = this.taskService.getTask(previousTaskId);
            if (deprecatedTaskToCancel != null && !deprecatedTaskToCancel.isCompleted()) {
                LOG.info("Cancel Previous Provisioning Task #{} to replace it with with Task #{} with transaction hash {}", new Object[]{previousTaskId, newTaskId, transactionHash});
                this.addComment(deprecatedTaskToCancel, "Tenant transaction replaced by task #" + newTaskId + " with transaction " + transactionHash);
                deprecatedTaskToCancel.setCompleted(true);
                deprecatedTaskToCancel.setPriority(Priority.NONE);
                this.taskService.updateTask(deprecatedTaskToCancel);
                this.removeTaskLabel(deprecatedTaskToCancel, this.transactionInProgressLabel);
                this.addTaskLabel(deprecatedTaskToCancel, this.transactionConflictLabel);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while canceling [REPLACED] Provisioning Task {} by new one {}", new Object[]{previousTaskId, newTaskId, e});
        }
    }
}

