/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantCommandListener
implements EventListener<DeedTenant> {
    private static final Logger LOG = LoggerFactory.getLogger(TenantCommandListener.class);
    public static final String LISTENER_NAME = "TenantCommandListener";
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("deed.event.tenantStart", "deed.event.tenantStop");
    @Autowired
    private TenantProvisioningService tenantProvisioningService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenant deedTenant) {
        LOG.info("A commad [{}] has been [RECEIVED] for deed {}", (Object)eventName, (Object)deedTenant.getNftId());
        try {
            if (StringUtils.equals((CharSequence)"deed.event.tenantStart", (CharSequence)eventName)) {
                this.tenantProvisioningService.startTenant(deedTenant.getNftId(), deedTenant.getStartupTransactionHash(), false);
            } else {
                this.tenantProvisioningService.stopTenant(deedTenant.getNftId(), deedTenant.getShutdownTransactionHash(), false);
            }
        }
        catch (Exception e) {
            LOG.warn("Error commanding [{}] Deed Tenant [{}]", new Object[]{eventName, deedTenant, e});
        }
    }
}

