/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.service;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.constant.TenantProvisioningStatus;
import io.meeds.deeds.constant.TenantStatus;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.ListenerService;
import io.meeds.deeds.storage.DeedTenantManagerRepository;
import io.meeds.tenant.provisioning.service.TaskIntegrationService;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class TenantProvisioningService {
    private static final String KNOWN_TRANSACTIONS_PROP_NAME = "knownTransactions";
    private static final Logger LOG = LoggerFactory.getLogger(TenantProvisioningService.class);
    public static final String DEED_EVENT_TENANT_CANCEL_COMMAND = "deed.event.tenantCancelCommand";
    public static final String DEED_EVENT_TENANT_STOP_COMMAND_CREATED = "deed.event.tenantStopCommandCreated";
    public static final String DEED_EVENT_TENANT_START_COMMAND_CREATED = "deed.event.tenantStartCommandCreated";
    public static final String DEED_EVENT_TENANT_COMPLETED_COMMAND = "deed.event.tenantCompletedCommand";
    public static final String DEED_EVENT_TENANT_STATUS_CHANGED = "deed.event.tenantStatusChanged";
    private static final List<TenantProvisioningStatus> PROVISIONING_PENDING_STATUSES = Arrays.asList(TenantProvisioningStatus.STOP_IN_PROGRESS, TenantProvisioningStatus.START_IN_PROGRESS);
    @Autowired
    private DeedTenantManagerRepository deedTenantManagerRepository;
    @Autowired
    private TaskIntegrationService taskIntegrationService;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private ListenerService listenerService;

    public List<DeedTenant> getTenants(TenantProvisioningStatus provisioningStatus, boolean includeCompleted, int limit) {
        PageRequest pageable = PageRequest.of((int)0, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"date"}));
        if (includeCompleted) {
            return this.deedTenantManagerRepository.findByTenantProvisioningStatus(provisioningStatus, (Pageable)pageable);
        }
        return this.deedTenantManagerRepository.findByTenantProvisioningStatusAndCompletedIsFalse(provisioningStatus, (Pageable)pageable);
    }

    public long getTenantsCount(TenantProvisioningStatus provisioningStatus, boolean includeCompleted) {
        if (includeCompleted) {
            return this.deedTenantManagerRepository.countByTenantProvisioningStatus(provisioningStatus);
        }
        return this.deedTenantManagerRepository.countByTenantProvisioningStatusAndCompletedIsFalse(provisioningStatus);
    }

    public void startTenant(long nftId, String transactionHash, boolean confirmed) throws ObjectNotFoundException {
        block5: {
            LOG.debug("A [startTenant] command has been SENT for nftId='{}' with transaction '{}' (confirmed='{}')", new Object[]{nftId, transactionHash, confirmed});
            DeedTenant deedTenant = null;
            try {
                deedTenant = this.deedTenantManagerRepository.findById((Object)nftId).orElse(new DeedTenant());
                deedTenant.setNftId(nftId);
                deedTenant.setStartupTransactionHash(transactionHash);
                deedTenant.setShutdownTransactionHash(null);
                deedTenant.setCompleted(false);
                this.setDeedNftProperties(deedTenant);
                this.setTenantProvisioningStatus(deedTenant, true, confirmed);
                this.setDeedProvisioningTransaction(deedTenant, transactionHash);
                this.saveDeedTenant(deedTenant);
                this.taskIntegrationService.saveTask(deedTenant, transactionHash, true, confirmed);
                LOG.debug("The [startTenant] command task has been CREATED for nftId='{}' with transaction '{}' (confirmed='{}')", new Object[]{nftId, transactionHash, confirmed});
                if (deedTenant == null) break block5;
                this.saveDeedTenant(deedTenant);
            }
            catch (Exception e) {
                try {
                    LOG.debug("The [startTenant] command task has NOT BEEN SAVED for nftId='{}' with transaction '{}' (confirmed='{}'). Error message='{}'", new Object[]{nftId, transactionHash, confirmed, e.getMessage()});
                    throw e;
                }
                catch (Throwable throwable) {
                    if (deedTenant != null) {
                        this.saveDeedTenant(deedTenant);
                        this.listenerService.publishEvent(DEED_EVENT_TENANT_START_COMMAND_CREATED, (Object)deedTenant);
                    }
                    throw throwable;
                }
            }
            this.listenerService.publishEvent(DEED_EVENT_TENANT_START_COMMAND_CREATED, (Object)deedTenant);
        }
    }

    public void stopTenant(long nftId, String transactionHash, boolean confirmed) throws ObjectNotFoundException {
        block5: {
            LOG.debug("A [stopTenant] command has been [SENT] for nftId='{}' with transaction '{}' (confirmed='{}')", new Object[]{nftId, transactionHash, confirmed});
            DeedTenant deedTenant = null;
            try {
                deedTenant = this.deedTenantManagerRepository.findById((Object)nftId).orElse(new DeedTenant());
                deedTenant.setNftId(nftId);
                deedTenant.setShutdownTransactionHash(transactionHash);
                deedTenant.setStartupTransactionHash(null);
                deedTenant.setCompleted(false);
                this.setDeedNftProperties(deedTenant);
                this.setTenantProvisioningStatus(deedTenant, false, confirmed);
                this.setDeedProvisioningTransaction(deedTenant, transactionHash);
                this.saveDeedTenant(deedTenant);
                this.taskIntegrationService.saveTask(deedTenant, transactionHash, false, confirmed);
                LOG.debug("The [stopTenant] command task has been [CREATED] for nftId='{}' with transaction '{}' (confirmed='{}')", new Object[]{nftId, transactionHash, confirmed});
                if (deedTenant == null) break block5;
                this.saveDeedTenant(deedTenant);
            }
            catch (Exception e) {
                try {
                    LOG.debug("The [stopTenant] command task has [NOT BEEN SAVED] for nftId='{}' with transaction '{}' (confirmed='{}'). Error message='{}'", new Object[]{nftId, transactionHash, confirmed, e.getMessage()});
                    throw e;
                }
                catch (Throwable throwable) {
                    if (deedTenant != null) {
                        this.saveDeedTenant(deedTenant);
                        this.listenerService.publishEvent(DEED_EVENT_TENANT_STOP_COMMAND_CREATED, (Object)deedTenant);
                    }
                    throw throwable;
                }
            }
            this.listenerService.publishEvent(DEED_EVENT_TENANT_STOP_COMMAND_CREATED, (Object)deedTenant);
        }
    }

    public void cancelTenantProvisioning(long nftId, String transactionHash) {
        LOG.debug("A [cancelTransaction] command has been [SENT] for nftId='{}' with transaction '{}')", (Object)nftId, (Object)transactionHash);
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById((Object)nftId).orElse(null);
        if (deedTenant != null) {
            if (this.blockchainService.isDeedStarted(nftId)) {
                deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.START_CONFIRMED);
            } else {
                deedTenant.setTenantProvisioningStatus(TenantProvisioningStatus.STOP_CONFIRMED);
            }
            deedTenant.setCompleted(true);
            this.saveDeedTenant(deedTenant);
            try {
                this.taskIntegrationService.cancelTask(deedTenant, transactionHash);
                LOG.debug("The [cancelTransaction] command task has been [CLOSED] for nftId='{}' with transaction '{}'", (Object)nftId, (Object)transactionHash);
            }
            catch (Exception e) {
                LOG.debug("The [cancelTransaction] command task has [NOT BEEN CLOSED] for nftId='{}' with transaction '{}'. Error message='{}'", new Object[]{nftId, transactionHash, e.getMessage()});
                throw e;
            }
            finally {
                this.listenerService.publishEvent(DEED_EVENT_TENANT_CANCEL_COMMAND, (Object)deedTenant);
            }
        }
    }

    public void saveDeedTenantStatus(long nftId, TenantStatus tenantStatus) throws ObjectNotFoundException {
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById((Object)nftId).orElse(null);
        if (deedTenant == null) {
            throw new ObjectNotFoundException("NFT with id " + nftId + " wasn't found");
        }
        this.setTenantStatus(deedTenant, tenantStatus);
        this.deedTenantManagerRepository.save((Object)deedTenant);
        this.listenerService.publishEvent(DEED_EVENT_TENANT_STATUS_CHANGED, (Object)deedTenant);
    }

    public void changeDeedTenantCompletedStatus(long taskId, boolean completed) {
        DeedTenant deedTenant = this.deedTenantManagerRepository.findByTaskId(String.valueOf(taskId)).findFirst().orElse(null);
        if (deedTenant != null && deedTenant.isCompleted() != completed) {
            deedTenant.setCompleted(completed);
            if (completed && deedTenant.getTenantProvisioningStatus() != null) {
                if (deedTenant.getTenantProvisioningStatus().isStart()) {
                    this.setTenantStatus(deedTenant, TenantStatus.DEPLOYED);
                } else {
                    this.setTenantStatus(deedTenant, TenantStatus.UNDEPLOYED);
                }
            }
            this.deedTenantManagerRepository.save((Object)deedTenant);
            this.listenerService.publishEvent(DEED_EVENT_TENANT_COMPLETED_COMMAND, (Object)deedTenant);
        }
    }

    public boolean isTransactionAlreadyConfirmed(String transactionHash, long nftId) {
        boolean transactionHashIsKnown;
        boolean newTenant;
        DeedTenant deedTenant = this.deedTenantManagerRepository.findById((Object)nftId).orElse(null);
        boolean bl = newTenant = deedTenant == null || deedTenant.getTenantProvisioningStatus() == null;
        if (newTenant) {
            return false;
        }
        boolean bl2 = transactionHashIsKnown = StringUtils.equalsIgnoreCase((CharSequence)transactionHash, (CharSequence)deedTenant.getStartupTransactionHash()) || StringUtils.equalsIgnoreCase((CharSequence)transactionHash, (CharSequence)deedTenant.getShutdownTransactionHash());
        if (transactionHashIsKnown) {
            return deedTenant.getTenantProvisioningStatus().isConfirmed();
        }
        String knownTransactions = deedTenant.getProperties() == null ? null : (String)deedTenant.getProperties().get(KNOWN_TRANSACTIONS_PROP_NAME);
        return StringUtils.containsIgnoreCase((CharSequence)knownTransactions, (CharSequence)transactionHash);
    }

    public boolean isManager(String userName) {
        return this.getManagers().contains(userName);
    }

    public List<DeedTenant> getPendingTransactions() {
        return this.deedTenantManagerRepository.findByTenantProvisioningStatusIn(PROVISIONING_PENDING_STATUSES);
    }

    public DeedTenant saveDeedTenant(DeedTenant minedDeedTenantTransaction) {
        return (DeedTenant)this.deedTenantManagerRepository.save((Object)minedDeedTenantTransaction);
    }

    public boolean isDeedExists(long nftId) {
        return this.deedTenantManagerRepository.existsById((Object)nftId);
    }

    public Set<String> getManagers() {
        return this.taskIntegrationService.getProjectManagers();
    }

    public String getManagerEmail(long nftId) throws ObjectNotFoundException {
        DeedTenant deedTenant = (DeedTenant)this.deedTenantManagerRepository.findById((Object)nftId).orElseThrow(() -> new ObjectNotFoundException("Deed Tenant not found"));
        return deedTenant.getManagerEmail();
    }

    private void setTenantProvisioningStatus(DeedTenant deedTenant, boolean start, boolean confirmed) {
        if (start) {
            if (confirmed) {
                this.setTenantProvisioningStatus(deedTenant, TenantProvisioningStatus.START_CONFIRMED);
            } else {
                this.setTenantProvisioningStatus(deedTenant, TenantProvisioningStatus.START_IN_PROGRESS);
            }
        } else if (confirmed) {
            this.setTenantProvisioningStatus(deedTenant, TenantProvisioningStatus.STOP_CONFIRMED);
        } else {
            this.setTenantProvisioningStatus(deedTenant, TenantProvisioningStatus.STOP_IN_PROGRESS);
        }
    }

    private void setTenantProvisioningStatus(DeedTenant deedTenant, TenantProvisioningStatus newStatus) {
        if (newStatus != deedTenant.getTenantProvisioningStatus()) {
            deedTenant.setTenantProvisioningStatus(newStatus);
            deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
        }
    }

    private void setTenantStatus(DeedTenant deedTenant, TenantStatus tenantStatus) {
        deedTenant.setTenantStatus(tenantStatus);
        deedTenant.setDate(LocalDateTime.now(ZoneOffset.UTC));
    }

    private void setDeedNftProperties(DeedTenant deedTenant) throws ObjectNotFoundException {
        try {
            if (deedTenant.getCardType() < 0) {
                short cardType = this.blockchainService.getDeedCardType(deedTenant.getNftId());
                deedTenant.setCardType(cardType);
            }
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error while retieving NFT ID {} card Type. Ignore for now.", (Object)deedTenant.getNftId());
        }
        try {
            if (deedTenant.getCityIndex() < 0) {
                short cityIndex = this.blockchainService.getDeedCityIndex(deedTenant.getNftId());
                deedTenant.setCityIndex(cityIndex);
            }
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Error while retieving NFT ID {} city. Ignore for now.", (Object)deedTenant.getNftId());
        }
    }

    private void setDeedProvisioningTransaction(DeedTenant deedTenant, String transactionHash) {
        String knownTransactions;
        if (deedTenant.getProperties() == null) {
            deedTenant.setProperties(new HashMap());
        }
        if (StringUtils.isBlank((CharSequence)(knownTransactions = (String)deedTenant.getProperties().get(KNOWN_TRANSACTIONS_PROP_NAME)))) {
            deedTenant.getProperties().put(KNOWN_TRANSACTIONS_PROP_NAME, transactionHash);
        } else {
            HashSet<String> knownTransactionsSet = new HashSet<String>(Arrays.asList(knownTransactions.split(",")));
            knownTransactionsSet.add(transactionHash);
            deedTenant.getProperties().put(KNOWN_TRANSACTIONS_PROP_NAME, StringUtils.join(knownTransactionsSet, (String)","));
        }
    }
}

