/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.springframework.hateoas.server.core.Relation;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="rewards", itemRelation="reward")
public class UemReward {
    private long rewardId;
    private double amount;
    private double fixedGlobalIndex;
    private Instant fromDate;
    private Instant toDate;
    private List<Long> reportIds;
    private Set<String> hubAddresses;
    private double sumEd;

    public long getReportsCount() {
        return this.reportIds == null ? 0L : (long)this.reportIds.size();
    }

    public double getEw() {
        return this.getReportsCount() == 0L ? 1.0 : BigDecimal.valueOf(this.sumEd).divide(BigDecimal.valueOf(this.getReportsCount()), MathContext.DECIMAL128).doubleValue();
    }

    public long getRewardId() {
        return this.rewardId;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getFixedGlobalIndex() {
        return this.fixedGlobalIndex;
    }

    public Instant getFromDate() {
        return this.fromDate;
    }

    public Instant getToDate() {
        return this.toDate;
    }

    public List<Long> getReportIds() {
        return this.reportIds;
    }

    public Set<String> getHubAddresses() {
        return this.hubAddresses;
    }

    public double getSumEd() {
        return this.sumEd;
    }

    public void setRewardId(long rewardId) {
        this.rewardId = rewardId;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setFixedGlobalIndex(double fixedGlobalIndex) {
        this.fixedGlobalIndex = fixedGlobalIndex;
    }

    public void setFromDate(Instant fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Instant toDate) {
        this.toDate = toDate;
    }

    public void setReportIds(List<Long> reportIds) {
        this.reportIds = reportIds;
    }

    public void setHubAddresses(Set<String> hubAddresses) {
        this.hubAddresses = hubAddresses;
    }

    public void setSumEd(double sumEd) {
        this.sumEd = sumEd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UemReward)) {
            return false;
        }
        UemReward other = (UemReward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRewardId() != other.getRewardId()) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getFixedGlobalIndex(), other.getFixedGlobalIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getSumEd(), other.getSumEd()) != 0) {
            return false;
        }
        Instant this$fromDate = this.getFromDate();
        Instant other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Instant this$toDate = this.getToDate();
        Instant other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        List<Long> this$reportIds = this.getReportIds();
        List<Long> other$reportIds = other.getReportIds();
        if (this$reportIds == null ? other$reportIds != null : !((Object)this$reportIds).equals(other$reportIds)) {
            return false;
        }
        Set<String> this$hubAddresses = this.getHubAddresses();
        Set<String> other$hubAddresses = other.getHubAddresses();
        return !(this$hubAddresses == null ? other$hubAddresses != null : !((Object)this$hubAddresses).equals(other$hubAddresses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UemReward;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rewardId = this.getRewardId();
        result = result * 59 + (int)($rewardId >>> 32 ^ $rewardId);
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $fixedGlobalIndex = Double.doubleToLongBits(this.getFixedGlobalIndex());
        result = result * 59 + (int)($fixedGlobalIndex >>> 32 ^ $fixedGlobalIndex);
        long $sumEd = Double.doubleToLongBits(this.getSumEd());
        result = result * 59 + (int)($sumEd >>> 32 ^ $sumEd);
        Instant $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Instant $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        List<Long> $reportIds = this.getReportIds();
        result = result * 59 + ($reportIds == null ? 43 : ((Object)$reportIds).hashCode());
        Set<String> $hubAddresses = this.getHubAddresses();
        result = result * 59 + ($hubAddresses == null ? 43 : ((Object)$hubAddresses).hashCode());
        return result;
    }

    public String toString() {
        return "UemReward(rewardId=" + this.getRewardId() + ", amount=" + this.getAmount() + ", fixedGlobalIndex=" + this.getFixedGlobalIndex() + ", fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", reportIds=" + this.getReportIds() + ", hubAddresses=" + this.getHubAddresses() + ", sumEd=" + this.getSumEd() + ")";
    }

    public UemReward() {
    }

    public UemReward(long rewardId, double amount, double fixedGlobalIndex, Instant fromDate, Instant toDate, List<Long> reportIds, Set<String> hubAddresses, double sumEd) {
        this.rewardId = rewardId;
        this.amount = amount;
        this.fixedGlobalIndex = fixedGlobalIndex;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.reportIds = reportIds;
        this.hubAddresses = hubAddresses;
        this.sumEd = sumEd;
    }
}

