/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.service;

import io.meeds.tenant.metamask.storage.TenantManagerStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class TenantManagerService
implements Startable {
    public static final String PROVISIONED_STATUS = "PROVISIONED";
    public static final String TENANT_STATUS_DOWN = "DOWN";
    public static final String TENANT_STATUS_UP = "UP";
    public static final String MANAGER_DEFAULT_ROLES_PARAM = "managerDefaultRoles";
    public static final String NFT_ID_PARAM = "nftId";
    protected static final Log LOG = ExoLogger.getLogger(TenantManagerService.class);
    private TenantManagerStorage tenantManagerStorage;
    private String nftId;
    private List<String> tenantManagerDefaultRoles = new ArrayList<String>();

    public TenantManagerService(TenantManagerStorage tenantManagerStorage, InitParams params) {
        this.tenantManagerStorage = tenantManagerStorage;
        this.tenantManagerDefaultRoles = this.getParamValues(params, MANAGER_DEFAULT_ROLES_PARAM);
        this.nftId = this.getParamValue(params, NFT_ID_PARAM);
    }

    public void start() {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            try {
                this.tenantManagerStorage.setTenantStatus(this.nftId, PROVISIONED_STATUS, TENANT_STATUS_UP);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while storing Tenant status as started", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            try {
                this.tenantManagerStorage.setTenantStatus(this.nftId, PROVISIONED_STATUS, TENANT_STATUS_DOWN);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while storing Tenant status as stopped", (Throwable)e);
            }
        }
    }

    public boolean isTenantManager(String userName) {
        String managerAddress = this.getManagerAddress();
        return StringUtils.isNotBlank((CharSequence)managerAddress) && StringUtils.equalsIgnoreCase((CharSequence)userName, (CharSequence)managerAddress);
    }

    public List<String> getTenantManagerDefaultRoles() {
        return Collections.unmodifiableList(this.tenantManagerDefaultRoles);
    }

    public String getManagerAddress() {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            return this.tenantManagerStorage.getManagerAddress(this.nftId);
        }
        return null;
    }

    public String getCityIndex() {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            return this.tenantManagerStorage.getCityIndex(this.nftId);
        }
        return null;
    }

    public String getCardType() {
        if (StringUtils.isNotBlank((CharSequence)this.nftId)) {
            return this.tenantManagerStorage.getCardType(this.nftId);
        }
        return null;
    }

    private String getParamValue(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValueParam(paramName).getValue();
        }
        return null;
    }

    private List<String> getParamValues(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValuesParam(paramName).getValues();
        }
        return Collections.emptyList();
    }
}

