/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.storage;

import io.meeds.deeds.contract.TenantProvisioningStrategy;
import java.math.BigInteger;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.datatypes.Address;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;

public class TenantManagerStorage {
    protected static final Log LOG = ExoLogger.getLogger(TenantManagerStorage.class);
    private Web3j web3j;
    private String networkUrl;
    private String tenantProvisioningAddress;

    public TenantManagerStorage(InitParams params) {
        if (params != null) {
            if (params.containsKey((Object)"networkUrl")) {
                this.networkUrl = params.getValueParam("networkUrl").getValue();
            }
            if (params.containsKey((Object)"tenantProvisioningAddress")) {
                this.tenantProvisioningAddress = params.getValueParam("tenantProvisioningAddress").getValue();
            }
        }
    }

    public boolean isManagerAddress(String nftId, String address) {
        try {
            return (Boolean)this.getTenantProvisioningContract().isProvisioningManager(address, new BigInteger(nftId)).send();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error checking Tenant Provisioning Manager", (Throwable)e);
            return false;
        }
    }

    public TenantProvisioningStrategy getTenantProvisioningContract() {
        BigInteger gasPrice = BigInteger.valueOf(20000000000L);
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        Web3j web3jInstance = this.getWeb3j();
        return TenantProvisioningStrategy.load((String)this.tenantProvisioningAddress, (Web3j)web3jInstance, (TransactionManager)new ReadonlyTransactionManager(web3jInstance, Address.DEFAULT.toString()), (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
    }

    public Web3j getWeb3j() {
        if (this.web3j == null) {
            this.web3j = Web3j.build((Web3jService)new HttpService(this.networkUrl));
        }
        return this.web3j;
    }
}

