/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class TenantProvisioningStrategy
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_ADDMANAGER = "addManager";
    public static final String FUNC_DEED = "deed";
    public static final String FUNC_DELEGATEES = "delegatees";
    public static final String FUNC_ISMANAGER = "isManager";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_ISPROVISIONINGMANAGER = "isProvisioningManager";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_REMOVEDELEGATEE = "removeDelegatee";
    public static final String FUNC_REMOVEMANAGER = "removeManager";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_SETDELEGATEE = "setDelegatee";
    public static final String FUNC_STARTTENANT = "startTenant";
    public static final String FUNC_STOPTENANT = "stopTenant";
    public static final String FUNC_TENANTSTATUS = "tenantStatus";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final Event DELEGATEEADDED_EVENT = new Event("DelegateeAdded", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Address>(true){}));
    public static final Event DELEGATEEREMOVED_EVENT = new Event("DelegateeRemoved", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}, new TypeReference<Address>(true){}));
    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));

    @Deprecated
    protected TenantProvisioningStrategy(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected TenantProvisioningStrategy(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected TenantProvisioningStrategy(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected TenantProvisioningStrategy(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<DelegateeAddedEventResponse> getDelegateeAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DELEGATEEADDED_EVENT, transactionReceipt);
        ArrayList<DelegateeAddedEventResponse> responses = new ArrayList<DelegateeAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DelegateeAddedEventResponse typedResponse = new DelegateeAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.manager = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.nftId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DelegateeAddedEventResponse> delegateeAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DelegateeAddedEventResponse>(){

            public DelegateeAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = TenantProvisioningStrategy.this.extractEventParametersWithLog(DELEGATEEADDED_EVENT, log);
                DelegateeAddedEventResponse typedResponse = new DelegateeAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.manager = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.nftId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DelegateeAddedEventResponse> delegateeAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DELEGATEEADDED_EVENT));
        return this.delegateeAddedEventFlowable(filter);
    }

    public List<DelegateeRemovedEventResponse> getDelegateeRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DELEGATEEREMOVED_EVENT, transactionReceipt);
        ArrayList<DelegateeRemovedEventResponse> responses = new ArrayList<DelegateeRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DelegateeRemovedEventResponse typedResponse = new DelegateeRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.manager = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.nftId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DelegateeRemovedEventResponse> delegateeRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DelegateeRemovedEventResponse>(){

            public DelegateeRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = TenantProvisioningStrategy.this.extractEventParametersWithLog(DELEGATEEREMOVED_EVENT, log);
                DelegateeRemovedEventResponse typedResponse = new DelegateeRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.manager = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.nftId = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DelegateeRemovedEventResponse> delegateeRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DELEGATEEREMOVED_EVENT));
        return this.delegateeRemovedEventFlowable(filter);
    }

    public List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ManagerAddedEventResponse>(){

            public ManagerAddedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = TenantProvisioningStrategy.this.extractEventParametersWithLog(MANAGERADDED_EVENT, log);
                ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERADDED_EVENT));
        return this.managerAddedEventFlowable(filter);
    }

    public List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ManagerRemovedEventResponse>(){

            public ManagerRemovedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = TenantProvisioningStrategy.this.extractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
                ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
                typedResponse.log = log;
                typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERREMOVED_EVENT));
        return this.managerRemovedEventFlowable(filter);
    }

    public List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, OwnershipTransferredEventResponse>(){

            public OwnershipTransferredEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = TenantProvisioningStrategy.this.extractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
                OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
                typedResponse.log = log;
                typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> deed() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> delegatees(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DELEGATEES, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISMANAGER, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isProvisioningManager(String _address, BigInteger _nftId) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISPROVISIONINGMANAGER, Arrays.asList(new Address(160, _address), new Uint256(_nftId)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeDelegatee(BigInteger _nftId) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVEDELEGATEE, Arrays.asList(new Uint256(_nftId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVEMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setDelegatee(String _address, BigInteger _nftId) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETDELEGATEE, Arrays.asList(new Address(160, _address), new Uint256(_nftId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> startTenant(BigInteger _nftId) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_STARTTENANT, Arrays.asList(new Uint256(_nftId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stopTenant(BigInteger _nftId) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_STOPTENANT, Arrays.asList(new Uint256(_nftId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> tenantStatus(BigInteger param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TENANTSTATUS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static TenantProvisioningStrategy load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new TenantProvisioningStrategy(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static TenantProvisioningStrategy load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new TenantProvisioningStrategy(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static TenantProvisioningStrategy load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new TenantProvisioningStrategy(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static TenantProvisioningStrategy load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new TenantProvisioningStrategy(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<TenantProvisioningStrategy> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _deed) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _deed)));
        return TenantProvisioningStrategy.deployRemoteCall(TenantProvisioningStrategy.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<TenantProvisioningStrategy> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _deed) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _deed)));
        return TenantProvisioningStrategy.deployRemoteCall(TenantProvisioningStrategy.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<TenantProvisioningStrategy> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _deed) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _deed)));
        return TenantProvisioningStrategy.deployRemoteCall(TenantProvisioningStrategy.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<TenantProvisioningStrategy> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _deed) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _deed)));
        return TenantProvisioningStrategy.deployRemoteCall(TenantProvisioningStrategy.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class ManagerRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class ManagerAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class DelegateeRemovedEventResponse
    extends BaseEventResponse {
        public String account;
        public String manager;
        public BigInteger nftId;
    }

    public static class DelegateeAddedEventResponse
    extends BaseEventResponse {
        public String account;
        public String manager;
        public BigInteger nftId;
    }
}

