/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.integration;

import io.meeds.tenant.integration.SpringContext;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Aspect
public class SpringIntegrationAspect {
    private static final Log LOG = ExoLogger.getLogger(SpringIntegrationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ SpringIntegrationAspect ajc$perSingletonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..)) && @annotation(io.meeds.tenant.integration.SpringIntegration)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        ClassLoader springClassLoader = SpringContext.getClassLoader();
        if (springClassLoader != null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(springClassLoader);
                Object object = point.proceed();
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        SpringIntegrationAspect.LOG.warn((Object)"Can't find spring context, class loader is null");
        return point.proceed();
    }

    static {
        try {
            SpringIntegrationAspect.ajc$perSingletonInstance = new SpringIntegrationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static SpringIntegrationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.meeds.tenant.integration.SpringIntegrationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

