/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.authenticator;

import io.meeds.tenant.metamask.service.MetamaskLoginService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.organization.auth.AuthenticatorPlugin;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.gatein.sso.agent.tomcat.ServletAccess;

public class MetamaskAuthenticator
extends AuthenticatorPlugin {
    private MetamaskLoginService metamaskLoginService;

    public MetamaskAuthenticator(MetamaskLoginService metamaskLoginService) {
        this.metamaskLoginService = metamaskLoginService;
    }

    public String validateUser(Credential[] credentials) {
        Credential credential;
        if (credentials != null && credentials.length == 2 && (credential = credentials[0]) instanceof UsernameCredential) {
            PasswordCredential passwordCredential;
            String compoundPassword;
            String[] passwordParts;
            UsernameCredential usernameCredential = (UsernameCredential)credential;
            credential = credentials[1];
            if (credential instanceof PasswordCredential && (passwordParts = StringUtils.split((String)(compoundPassword = (passwordCredential = (PasswordCredential)credential).getPassword()), (String)"@")) != null) {
                String signedMessage;
                String rawMessage;
                String walletAddress;
                if (passwordParts.length == 2 && "SIGNED_MESSAGE@".replace("@", "").equals(passwordParts[0])) {
                    walletAddress = usernameCredential.getUsername();
                    rawMessage = this.metamaskLoginService.getLoginMessage(ServletAccess.getRequest().getSession());
                    signedMessage = passwordParts[1];
                } else if (passwordParts.length == 3) {
                    walletAddress = passwordParts[0];
                    rawMessage = passwordParts[1];
                    signedMessage = passwordParts[2];
                } else {
                    return null;
                }
                boolean validated = this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage);
                if (validated) {
                    String username = this.metamaskLoginService.getUserWithWalletAddress(walletAddress);
                    return StringUtils.isBlank((CharSequence)username) ? walletAddress : username;
                }
            }
        }
        return null;
    }
}

