/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.VerifiableData;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Arrays;
import java.util.SortedSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.hateoas.server.core.Relation;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="reports", itemRelation="report")
public class HubReportVerifiableData
extends HubReportPayload
implements VerifiableData {
    private String hash;
    private String signature;

    public HubReportVerifiableData(String hash, String signature, long reportId, String hubAddress, long deedId, Instant fromDate, Instant toDate, Instant sentDate, String periodType, long usersCount, long participantsCount, long recipientsCount, long achievementsCount, long actionsCount, String rewardTokenAddress, long rewardTokenNetworkId, double hubRewardAmount, double hubTopReceiverAmount, SortedSet<String> transactions) {
        super(reportId, hubAddress, deedId, fromDate, toDate, sentDate, periodType, usersCount, participantsCount, recipientsCount, achievementsCount, actionsCount, rewardTokenAddress, rewardTokenNetworkId, hubRewardAmount, hubTopReceiverAmount, transactions);
        this.hash = hash;
        this.signature = signature;
    }

    public HubReportVerifiableData(String hash, String signature, HubReportPayload reportData) {
        this(hash, signature, reportData.getReportId(), reportData.getHubAddress(), reportData.getDeedId(), reportData.getFromDate(), reportData.getToDate(), reportData.getSentDate(), reportData.getPeriodType(), reportData.getUsersCount(), reportData.getParticipantsCount(), reportData.getRecipientsCount(), reportData.getAchievementsCount(), reportData.getActionsCount(), reportData.getRewardTokenAddress(), reportData.getRewardTokenNetworkId(), reportData.getHubRewardAmount(), reportData.getHubTopRewardedAmount(), reportData.getTransactions());
    }

    public void setHash(String hash) {
        this.hash = StringUtils.lowerCase((String)hash);
    }

    @Override
    public String generateHash() {
        return StringUtils.lowerCase((String)Hash.sha3((String)this.signature));
    }

    @Override
    public boolean isValid() throws SignatureException {
        return this.isValidHash() && this.isValidMessageSignature();
    }

    private boolean isValidMessageSignature() throws SignatureException {
        String hubAddress = this.getHubAddress();
        String rawMessage = this.generateRawMessage();
        if (StringUtils.isBlank((CharSequence)hubAddress) || StringUtils.isBlank((CharSequence)this.signature) || StringUtils.isBlank((CharSequence)rawMessage)) {
            return false;
        }
        byte[] signatureBytes = Numeric.hexStringToByteArray((String)this.signature);
        if (signatureBytes.length < 64) {
            return false;
        }
        byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
        byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
        byte v = signatureBytes[64];
        if (v < 27) {
            v = (byte)(v + 27);
        }
        BigInteger publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(StandardCharsets.UTF_8), (Sign.SignatureData)new Sign.SignatureData(v, r, s));
        return StringUtils.equalsIgnoreCase((CharSequence)hubAddress, (CharSequence)("0x" + Keys.getAddress((BigInteger)publicKey)));
    }

    @Override
    @Generated
    public String toString() {
        return "HubReportVerifiableData(super=" + super.toString() + ", hash=" + this.getHash() + ", signature=" + this.getSignature() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubReportVerifiableData)) {
            return false;
        }
        HubReportVerifiableData other = (HubReportVerifiableData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HubReportVerifiableData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    @Generated
    public HubReportVerifiableData() {
    }

    @Override
    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }
}

