/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web.filter;

import io.meeds.tenant.metamask.RegistrationException;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.filter.Filter;
import org.json.JSONException;
import org.json.JSONObject;

public class MetamaskSignInFilter
extends JspBasedWebHandler
implements Filter {
    public static final Log LOG = ExoLogger.getLogger(MetamaskSignInFilter.class);
    public static final String METAMASK_REGISTER_FORM = "/WEB-INF/jsp/metamaskRegisterForm.jsp";
    public static final String EMAIL_REQUEST_PARAM = "email";
    public static final String FULL_NAME_REQUEST_PARAM = "fullName";
    public static final String ERROR_CODE_PARAM = "errorCode";
    public static final String SEPARATOR = "@";
    public static final String METAMASK_AUTHENTICATED = "metamask.authenticated";
    public static final String METAMASK_REGISTER_USER = "metamaskUserRegistration";
    public static final String USERNAME_REQUEST_PARAM = "username";
    public static final String PASSWORD_REQUEST_PARAM = "password";
    public static final String METAMASK_SIGNED_MESSAGE_PREFIX = "SIGNED_MESSAGE@";
    private static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
    private MetamaskLoginService metamaskLoginService;
    private WebAppController webAppController;
    private ServletContext servletContext;

    public MetamaskSignInFilter(PortalContainer container, WebAppController webAppController, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, MetamaskLoginService metamaskLoginService) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.webAppController = webAppController;
        this.metamaskLoginService = metamaskLoginService;
        this.servletContext = container.getPortalContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            boolean isRegistrationRequest;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String walletAddress = request.getParameter(USERNAME_REQUEST_PARAM);
            String password = request.getParameter(PASSWORD_REQUEST_PARAM);
            boolean bl = isRegistrationRequest = request.getParameter(METAMASK_REGISTER_USER) != null;
            if (isRegistrationRequest) {
                walletAddress = (String)request.getSession().getAttribute(USERNAME_REQUEST_PARAM);
                password = (String)request.getSession().getAttribute(PASSWORD_REQUEST_PARAM);
            }
            if (request.getRemoteUser() == null && StringUtils.isNotBlank((CharSequence)walletAddress) && (StringUtils.startsWith((CharSequence)password, (CharSequence)METAMASK_SIGNED_MESSAGE_PREFIX) || this.metamaskLoginService.isSuperUser(walletAddress) || this.metamaskLoginService.isAllowUserRegistration(walletAddress))) {
                if (StringUtils.startsWith((CharSequence)password, (CharSequence)METAMASK_SIGNED_MESSAGE_PREFIX)) {
                    String username = this.metamaskLoginService.getUserWithWalletAddress(walletAddress);
                    if (StringUtils.isBlank((CharSequence)username)) {
                        String signedMessage;
                        String rawMessage = this.metamaskLoginService.getLoginMessage(request.getSession());
                        boolean messageValidated = this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage = password.replace(METAMASK_SIGNED_MESSAGE_PREFIX, ""));
                        if (messageValidated) {
                            request.getSession().setAttribute(USERNAME_REQUEST_PARAM, (Object)walletAddress);
                            request.getSession().setAttribute(PASSWORD_REQUEST_PARAM, (Object)this.getCompoundPassword(request));
                        }
                        String errorCode = messageValidated ? null : "INVALID_CREDENTIALS";
                        this.forwardUserRegistrationForm(new ControllerContext(this.webAppController, this.webAppController.getRouter(), request, response, null), errorCode);
                        return;
                    }
                    String compoundPassword = this.getCompoundPassword(request);
                    servletRequest = this.wrapRequestForLogin(request, username, compoundPassword);
                } else if (isRegistrationRequest && (servletRequest = this.registerUserAndWrapRequestForLogin(request, response)) == null) {
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while registering user using metamask", (Throwable)e);
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    protected void forwardUserRegistrationForm(ControllerContext controllerContext, String errorCode) throws Exception {
        this.prepareDispatch(controllerContext, errorCode);
        this.servletContext.getRequestDispatcher(METAMASK_REGISTER_FORM).include((ServletRequest)controllerContext.getRequest(), (ServletResponse)controllerContext.getResponse());
    }

    protected boolean prepareDispatch(ControllerContext controllerContext, String errorCode) throws Exception {
        if (controllerContext == null) {
            return false;
        }
        List<String> additionalCSSModules = Collections.singletonList("portal/login");
        HttpServletRequest request = controllerContext.getRequest();
        super.prepareDispatch(controllerContext, "SHARED/metamaskRegisterForm", null, additionalCSSModules, params -> this.addRegisterFormParams((JSONObject)params, request, errorCode));
        return true;
    }

    protected void addRegisterFormParams(JSONObject params, HttpServletRequest request, String errorCode) {
        HttpSession session = request.getSession();
        try {
            params.put(USERNAME_REQUEST_PARAM, session.getAttribute(USERNAME_REQUEST_PARAM));
            params.put(FULL_NAME_REQUEST_PARAM, (Object)request.getParameter(FULL_NAME_REQUEST_PARAM));
            params.put(EMAIL_REQUEST_PARAM, (Object)request.getParameter(EMAIL_REQUEST_PARAM));
            params.put("rememberme", (Object)request.getParameter("rememberme"));
            if (StringUtils.isNotBlank((CharSequence)errorCode)) {
                params.put(ERROR_CODE_PARAM, (Object)errorCode);
            }
        }
        catch (JSONException e) {
            LOG.warn((Object)"Error putting error code in parameters", (Throwable)e);
        }
    }

    protected HttpServletRequest registerUserAndWrapRequestForLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String walletAddress = (String)request.getSession().getAttribute(USERNAME_REQUEST_PARAM);
        String password = (String)request.getSession().getAttribute(PASSWORD_REQUEST_PARAM);
        String fullName = request.getParameter(FULL_NAME_REQUEST_PARAM);
        String email = request.getParameter(EMAIL_REQUEST_PARAM);
        try {
            String errorCode;
            if (StringUtils.isNotBlank((CharSequence)email) && StringUtils.isNotBlank((CharSequence)(errorCode = EMAIL_VALIDATOR.validate(request.getLocale(), email)))) {
                throw new RegistrationException(errorCode);
            }
            if (!this.validateCompoundPassword(walletAddress, password)) {
                throw new RegistrationException("REGISTRATION_NOT_ALLOWED");
            }
            User user = this.metamaskLoginService.registerUser(walletAddress, fullName, email);
            return this.wrapRequestForLogin(request, user.getUserName(), password);
        }
        catch (RegistrationException e) {
            String errorCode = e.getMessage();
            this.forwardUserRegistrationForm(new ControllerContext(this.webAppController, this.webAppController.getRouter(), request, response, null), errorCode);
        }
        catch (Exception e) {
            this.forwardUserRegistrationForm(new ControllerContext(this.webAppController, this.webAppController.getRouter(), request, response, null), "REGISTRATION_ERROR");
        }
        return null;
    }

    private HttpServletRequestWrapper wrapRequestForLogin(HttpServletRequest request, final String username, final String password) {
        return new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                if (StringUtils.equals((CharSequence)name, (CharSequence)MetamaskSignInFilter.USERNAME_REQUEST_PARAM)) {
                    return username;
                }
                if (StringUtils.equals((CharSequence)name, (CharSequence)MetamaskSignInFilter.PASSWORD_REQUEST_PARAM)) {
                    return password;
                }
                return super.getParameter(name);
            }

            public String getRequestURI() {
                return this.getContextPath() + "/login";
            }
        };
    }

    protected String getCompoundPassword(HttpServletRequest request) {
        String walletAddress = request.getParameter(USERNAME_REQUEST_PARAM);
        String password = request.getParameter(PASSWORD_REQUEST_PARAM);
        String rawMessage = this.metamaskLoginService.getLoginMessage(request.getSession());
        String signedMessage = password.replace(METAMASK_SIGNED_MESSAGE_PREFIX, "");
        return walletAddress + SEPARATOR + rawMessage + SEPARATOR + signedMessage;
    }

    private boolean validateCompoundPassword(String walletAddress, String compoundPassword) {
        String[] passwordParts = StringUtils.split((String)compoundPassword, (String)SEPARATOR);
        if (passwordParts != null && passwordParts.length == 3) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)walletAddress, (CharSequence)passwordParts[0])) {
                return false;
            }
            String rawMessage = passwordParts[1];
            String signedMessage = passwordParts[2];
            return this.metamaskLoginService.validateSignedMessage(walletAddress, rawMessage, signedMessage);
        }
        return false;
    }
}

