/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.listener;

import io.meeds.tenant.service.TenantManagerService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.service.WalletAccountService;
import org.web3j.crypto.WalletUtils;

public class NewMetamaskCreatedUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewMetamaskCreatedUserListener.class);
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private WalletAccountService walletAccountService;
    private TenantManagerService tenantManagerService;

    public NewMetamaskCreatedUserListener(IdentityManager identityManager, OrganizationService organizationService, WalletAccountService walletAccountService, TenantManagerService tenantManagerService) {
        this.organizationService = organizationService;
        this.walletAccountService = walletAccountService;
        this.tenantManagerService = tenantManagerService;
        this.identityManager = identityManager;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        String address = user.getUserName();
        if (!(isNew && user.isEnabled() && WalletUtils.isValidAddress((String)address))) {
            return;
        }
        Wallet wallet = this.walletAccountService.getWalletByAddress(address);
        if (wallet != null) {
            LOG.info("Wallet with address {} is already associated to identity id {}.The used Metamask address will not be associated to current user account.", new Object[]{address, wallet.getTechnicalId()});
            return;
        }
        this.createUserWalletByAddress(address);
        if (this.isTenantManager(address)) {
            this.setTenantManagerRoles(user);
        }
    }

    private Wallet createUserWalletByAddress(String address) {
        try {
            Identity identity = this.identityManager.getOrCreateUserIdentity(address);
            Wallet userWallet = this.walletAccountService.createWalletInstance(WalletProvider.METAMASK, address, Long.valueOf(identity.getId()).longValue());
            return this.walletAccountService.saveWallet(userWallet, true);
        }
        catch (Exception e) {
            LOG.warn("Error while associating Metamask wallet for user {}", new Object[]{address, e});
            return null;
        }
    }

    private boolean isTenantManager(String walletAddress) {
        return this.tenantManagerService.isTenant() && this.tenantManagerService.isTenantManager(walletAddress);
    }

    private void setTenantManagerRoles(User user) {
        List<String> tenantManagerRoles = this.tenantManagerService.getTenantManagerDefaultRoles();
        LOG.info((Object)"Tenant manager registered, setting its default memberships as manager.");
        for (String role : tenantManagerRoles) {
            if (!StringUtils.isNotBlank((CharSequence)role)) continue;
            LOG.info("Add Tenant manager membership {}.", new Object[]{role});
            if (StringUtils.contains((CharSequence)role, (CharSequence)":")) {
                String[] roleParts = StringUtils.split((String)role, (String)":");
                String membershipTypeId = roleParts[0];
                String groupId = roleParts[1];
                this.addUserToGroup(user, groupId, membershipTypeId);
                continue;
            }
            this.addUserToGroup(user, role, "*");
        }
    }

    private void addUserToGroup(User user, String groupId, String membershipTypeId) {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        MembershipHandler membershipHandler = this.organizationService.getMembershipHandler();
        MembershipTypeHandler membershipTypeHandler = this.organizationService.getMembershipTypeHandler();
        try {
            Group group = groupHandler.findGroupById(groupId);
            MembershipType membershipType = membershipTypeHandler.findMembershipType(membershipTypeId);
            if (group != null && membershipType != null) {
                membershipHandler.linkMembership(user, group, membershipType, true);
            } else if (group == null) {
                LOG.warn("Group with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{groupId, membershipTypeId + ":" + groupId});
            } else {
                LOG.warn("Membership Type with id {} wasn't found. Tenant manager membership {} will not be set.", new Object[]{membershipTypeId, membershipTypeId + ":" + groupId});
            }
        }
        catch (Exception e) {
            LOG.warn("Error while adding user {} to role {}:{}", new Object[]{user.getUserName(), membershipTypeId, groupId, e});
        }
    }
}

