/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.storage;

import io.meeds.tenant.hub.storage.HubReportStorage;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.reward.service.RewardReportService;
import java.time.Instant;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={HubReportStorage.class})
@ExtendWith(value={MockitoExtension.class})
class HubReportStorageTest {
    @MockBean
    private SettingService settingService;
    @MockBean
    private RewardReportService rewardReportService;
    @Autowired
    private HubReportStorage hubReportStorage;
    @Mock
    private RewardPeriod rewardPeriod;
    private long periodId = 53L;
    private long reportId = 356L;
    private Instant sentDate = Instant.now().minusSeconds(500L);

    HubReportStorageTest() {
    }

    @Test
    void saveStatus() {
        String status = "NEW";
        this.hubReportStorage.saveStatus(this.periodId, status);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_REPORT_STATUS_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.periodId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)status, (CharSequence)setting.getValue().toString())));
    }

    @Test
    void saveStatusByPeriodHavingId() {
        String status = "NEW";
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        this.hubReportStorage.saveStatus(this.rewardPeriod, status);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_REPORT_STATUS_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.periodId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)status, (CharSequence)setting.getValue().toString())));
    }

    @Test
    void saveStatusByPeriodNotHavingId() {
        String status = "NEW";
        Assertions.assertThrows(IllegalStateException.class, () -> this.hubReportStorage.saveStatus(this.rewardPeriod, status));
    }

    @Test
    void saveStatusByPeriodHavingIdRetrievedFromStore() {
        String status = "NEW";
        RewardPeriodType periodType = RewardPeriodType.WEEK;
        LocalDate periodMedianDate = LocalDate.now();
        Mockito.when((Object)this.rewardPeriod.getRewardPeriodType()).thenReturn((Object)periodType);
        Mockito.when((Object)this.rewardPeriod.getPeriodMedianDate()).thenReturn((Object)periodMedianDate);
        RewardPeriod rewardPeriodFromStore = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)this.rewardReportService.getRewardPeriod(periodType, periodMedianDate)).thenReturn((Object)rewardPeriodFromStore);
        Mockito.when((Object)rewardPeriodFromStore.getId()).thenReturn((Object)this.periodId);
        this.hubReportStorage.saveStatus(this.rewardPeriod, status);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_REPORT_STATUS_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.periodId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)status, (CharSequence)setting.getValue().toString())));
    }

    @Test
    void saveReportPeriodId() {
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        this.hubReportStorage.saveReportPeriodId(this.rewardPeriod, this.reportId);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_REPORT_ID_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.periodId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)String.valueOf(this.reportId), (CharSequence)setting.getValue().toString())));
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_PERIOD_ID_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.reportId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)String.valueOf(this.periodId), (CharSequence)setting.getValue().toString())));
    }

    @Test
    void saveSentDate() {
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        this.hubReportStorage.saveSentDate(this.rewardPeriod, this.sentDate);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)ArgumentMatchers.eq((Object)HubReportStorage.UEM_CONTEXT), (Scope)ArgumentMatchers.eq((Object)HubReportStorage.REWARD_REPORT_SENT_DATE_APPLICATION), (String)ArgumentMatchers.eq((Object)String.valueOf(this.periodId)), (SettingValue)ArgumentMatchers.argThat(setting -> StringUtils.equals((CharSequence)String.valueOf(this.sentDate.toEpochMilli()), (CharSequence)setting.getValue().toString())));
    }

    @Test
    void getStatus() {
        String status = "SENT";
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        Assertions.assertNull((Object)this.hubReportStorage.getStatus(this.rewardPeriod));
        Mockito.when((Object)this.settingService.get(HubReportStorage.UEM_CONTEXT, HubReportStorage.REWARD_REPORT_STATUS_APPLICATION, String.valueOf(this.periodId))).thenAnswer(invocation -> SettingValue.create((String)status));
        Assertions.assertEquals((Object)status, (Object)this.hubReportStorage.getStatus(this.rewardPeriod));
    }

    @Test
    void getReportId() {
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        Assertions.assertEquals((long)0L, (long)this.hubReportStorage.getReportId(this.rewardPeriod));
        Mockito.when((Object)this.settingService.get(HubReportStorage.UEM_CONTEXT, HubReportStorage.REWARD_REPORT_ID_APPLICATION, String.valueOf(this.periodId))).thenAnswer(invocation -> SettingValue.create((String)String.valueOf(this.reportId)));
        Assertions.assertEquals((long)this.reportId, (long)this.hubReportStorage.getReportId(this.rewardPeriod));
    }

    @Test
    void getPeriodId() {
        Assertions.assertEquals((long)0L, (long)this.hubReportStorage.getPeriodId(this.reportId));
        Mockito.when((Object)this.settingService.get(HubReportStorage.UEM_CONTEXT, HubReportStorage.REWARD_PERIOD_ID_APPLICATION, String.valueOf(this.reportId))).thenAnswer(invocation -> SettingValue.create((String)String.valueOf(this.periodId)));
        Assertions.assertEquals((long)this.periodId, (long)this.hubReportStorage.getPeriodId(this.reportId));
    }

    @Test
    void getSentDate() {
        Mockito.when((Object)this.rewardPeriod.getId()).thenReturn((Object)this.periodId);
        Assertions.assertNotNull((Object)this.hubReportStorage.getSentDate(this.rewardPeriod));
        Assertions.assertNotEquals((long)this.sentDate.toEpochMilli(), (long)this.hubReportStorage.getSentDate(this.rewardPeriod).toEpochMilli());
        Mockito.when((Object)this.settingService.get(HubReportStorage.UEM_CONTEXT, HubReportStorage.REWARD_REPORT_SENT_DATE_APPLICATION, String.valueOf(this.periodId))).thenAnswer(invocation -> SettingValue.create((String)String.valueOf(this.sentDate.toEpochMilli())));
        Assertions.assertEquals((long)this.sentDate.toEpochMilli(), (long)this.hubReportStorage.getSentDate(this.rewardPeriod).toEpochMilli());
    }
}

