/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import io.meeds.tenant.metamask.web.MetamaskRegisterExtension;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.Map;
import org.exoplatform.web.ControllerContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={MetamaskRegisterExtension.class})
class MetamaskRegisterExtensionTest {
    @MockBean
    private MetamaskLoginService metamaskLoginService;
    @MockBean
    private HubService hubService;
    @Autowired
    private MetamaskRegisterExtension metamaskRegisterExtension;

    MetamaskRegisterExtensionTest() {
    }

    @Test
    void testGetExtensionName() {
        Assertions.assertEquals(Arrays.asList("RegisterExtension", "LoginExtension"), (Object)this.metamaskRegisterExtension.getExtensionNames());
    }

    @Test
    void testExtendParametersForLogin() {
        Mockito.when((Object)this.metamaskLoginService.isAllowUserRegistration()).thenReturn((Object)true);
        Map extendParameters = this.metamaskRegisterExtension.extendParameters(null, "LoginExtension");
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((Object)true, extendParameters.get("registerEnabled"));
        Assertions.assertEquals((int)1, (int)extendParameters.size());
        Mockito.when((Object)this.metamaskLoginService.isAllowUserRegistration()).thenReturn((Object)false);
        extendParameters = this.metamaskRegisterExtension.extendParameters(null, "LoginExtension");
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((int)0, (int)extendParameters.size());
    }

    @Test
    void testExtendParametersForRegister() {
        String rawMessage = "rawMessage";
        Mockito.when((Object)this.metamaskLoginService.isAllowUserRegistration()).thenReturn((Object)true);
        ControllerContext controllerContext = (ControllerContext)Mockito.mock(ControllerContext.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)controllerContext.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getSession(ArgumentMatchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)this.metamaskLoginService.generateLoginMessage(session)).thenReturn((Object)rawMessage);
        Map extendParameters = this.metamaskRegisterExtension.extendParameters(controllerContext, "RegisterExtension");
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((int)2, (int)extendParameters.size());
        Assertions.assertEquals((Object)true, extendParameters.get("metamaskRegistrationEnabled"));
        Assertions.assertEquals((Object)rawMessage, extendParameters.get("rawMessage"));
        Mockito.when((Object)this.metamaskLoginService.isAllowUserRegistration()).thenReturn((Object)false);
        extendParameters = this.metamaskRegisterExtension.extendParameters(controllerContext, "RegisterExtension");
        Assertions.assertNotNull((Object)extendParameters);
        Assertions.assertEquals((int)0, (int)extendParameters.size());
    }
}

