/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.social.category.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import io.meeds.social.category.plugin.CategoryPlugin;

@Service
public class CategoryPluginServiceImpl implements CategoryPluginService {

  @Autowired
  private List<CategoryPlugin>        categoryPlugins;

  private Map<String, CategoryPlugin> categoryPluginsByType = new HashMap<>();

  @Override
  public CategoryPlugin getCategoryPlugin(String objectType) {
    return categoryPluginsByType.computeIfAbsent(objectType,
                                                 t -> categoryPlugins.stream()
                                                                     .filter(c -> c.getType().equals(t))
                                                                     .findFirst()
                                                                     .orElseThrow());
  }

  @Override
  public boolean canEdit(String objectType, String objectId, String username) {
    return getCategoryPlugin(objectType).canEdit(objectId, username);
  }

  @Override
  public List<Long> getCategoryIds(String objectType) {
    return getCategoryPlugin(objectType).getCategoryIds();
  }

}
