# Contributing to Meeds

## Special thanks!

First of all, we (the Meeds community) are thankful for all project contributors who reported issues, gave some feedback, or contributed to a pull request.
We strive to fairly reward all kinds of contributions and for that, we have a program in place.

## Setup your Builders account

Before you start, we highly suggest you follow the following steps so you can be eligible for rewards automatically by interacting with GitHub and Meeds Builders' Hub.

1. Sign Up on [Meeds Builders's Hub](https://meeds.io)
2. Setup your [Wallet](https://builders.meeds.io/portal/meeds/wallet) to be ready to receive MEED rewards
3. Go to your [Profile](https://builders.meeds.io/portal/meeds/profile) page and connect it to GitHub in _Your other profiles_ block
4. Join the [Developers](https://builders.meeds.io/portal/g/:spaces:developers)

That's it, you are now ready to earn points with your contributions.

## How to report an issue or a feedback?

A single location has been added to create bugs and feedback issues for **all projects of Meeds-io** :
- https://github.com/Meeds-io/meeds/issues/new/choose


## How to contribute some code?

1. Pick a READY issue from the [Community Contributions Board](https://builders.meeds.io/portal/g/:spaces:developers/developers/tasks/projectDetail/50)
2. Implement the solution following our [Coding Guidelines](https://github.com/Meeds-io/meeds/blob/develop/CODING_GUIDELINES.md)
3. When you're ready, submit a pull request (to push code to _develop_ branch) using the [Pull Request Template](https://github.com/Meeds-io/meeds/blob/develop/.github/PULL_REQUEST_TEMPLATE.md). Make sure you do a _clear_ description of the solution.

Once you submit your pull request, we (the Meeds community) will try to make the review and integrate it in a future version if validated.

__Note__: For [Meeds](https://www.meeds.io/about-us/#about-us) Association members, you will have to follow the same process of issue & PR creations with the possibility to merge pull requests without seeking consensus with other members.


## How to submit a Meed Improvement Proposal?

To submit more elaborated feedback with a functional and technical design of a concept, you can submit an MIP at this location:
- https://github.com/Meeds-io/MIPs/issues/new/choose



Thanks!
The [Meeds](https://meeds.io) Core Team
