/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2023 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


export function getSites(siteType, excludedSiteType, excludedSiteName, excludeEmptyNavigationSites, excludeSpaceSites, expandNavigations, filterByDisplayed, sortByDisplayOrder, displayed, filterByPermissions, excludeGroupNodesWithoutPageChildNodes, temporalCheck, visibility) {
  return getSitesByFilter({
    siteType,
    excludedSiteType,
    excludedSiteName,
    excludeEmptyNavigationSites,
    excludeSpaceSites,
    expandNavigations,
    filterByDisplayed,
    sortByDisplayOrder,
    displayed,
    filterByPermissions,
    excludeGroupNodesWithoutPageChildNodes,
    temporalCheck,
    visibility
  });
}

export function getSitesByFilter({
  siteType,
  excludedSiteType,
  excludedSiteName,
  excludeEmptyNavigationSites,
  excludeSpaceSites,
  expandNavigations,
  filterByDisplayed,
  sortByDisplayOrder,
  displayed,
  filterByPermissions,
  excludeGroupNodesWithoutPageChildNodes,
  temporalCheck,
  visibility,
  expand
}) {
  const formData = new FormData();
  if (siteType) {
    formData.append('siteType', siteType);
  }
  if (excludedSiteType) {
    formData.append('excludedSiteType', excludedSiteType);
  }

  if (excludedSiteName) {
    formData.append('excludedSiteName', excludedSiteName);
  }
  formData.append('lang', eXo.env.portal.language);
  formData.append('excludeEmptyNavigationSites', excludeEmptyNavigationSites || false);
  formData.append('excludeGroupNodesWithoutPageChildNodes', excludeGroupNodesWithoutPageChildNodes || false);
  formData.append('temporalCheck', temporalCheck || false);
  formData.append('excludeSpaceSites', excludeSpaceSites || false);
  formData.append('expandNavigations', expandNavigations || false);
  if (visibility) {
    visibility.forEach(visibility => {
      formData.append('visibility', visibility);
    });
  }
  formData.append('filterByDisplayed', filterByDisplayed || false);
  formData.append('sortByDisplayOrder', sortByDisplayOrder || false);
  if (filterByDisplayed) {
    formData.append('displayed', displayed);
  }
  if (expand) {
    formData.append('expand', expand);
  }
  formData.append('filterByPermissions', filterByPermissions || false);
  const params = new URLSearchParams(formData).toString();

  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/social/sites?${params}`, {
    method: 'GET',
    credentials: 'include',
  }).then(resp => {
    if (resp?.ok) {
      return resp.json().catch(() => []);
    } else {
      throw new Error('Error while getting sites');
    }
  });
}

export function getSite(siteType, siteName, params) {
  const formData = new FormData();
  if (params?.lang) {
    formData.append('lang', params?.lang);
  }
  if (params?.excludeEmptyNavigationSites) {
    formData.append('excludeEmptyNavigationSites', params.excludeEmptyNavigationSites);
  }
  if (params?.expandNavigations) {
    formData.append('expandNavigations', params.expandNavigations);
  }
  if (params?.excludeEmptyNavigationSites) {
    formData.append('excludeEmptyNavigationSites', params.excludeEmptyNavigationSites);
  }
  if (params?.excludeGroupNodesWithoutPageChildNodes) {
    formData.append('excludeGroupNodesWithoutPageChildNodes', params.excludeGroupNodesWithoutPageChildNodes);
  }
  if (params?.temporalCheck) {
    formData.append('temporalCheck', params.temporalCheck);
  }
  if (params?.visibility) {
    params.visibility.forEach(visibility => {
      formData.append('visibility', visibility);
    });
  }
  const dataParams = new URLSearchParams(formData).toString();
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/social/sites/${siteType}/${siteName.replaceAll('/', ':')}?${dataParams}`, {
    method: 'GET',
    credentials: 'include',
  }).then(resp => {
    if (resp?.ok) {
      return resp.json().catch(() => []);
    } else {
      throw new Error('Error while getting site by type and name');
    }
  });
}

export function getSiteById(siteId, params) {
  const formData = new FormData();
  formData.append('lang', params?.lang || eXo.env.portal.language);
  if (params?.excludeEmptyNavigationSites) {
    formData.append('excludeEmptyNavigationSites', params?.excludeEmptyNavigationSites);
  }
  if (params?.expandNavigations) {
    formData.append('expandNavigations', params?.expandNavigations);
  }
  if (params?.excludeGroupNodesWithoutPageChildNodes) {
    formData.append('excludeGroupNodesWithoutPageChildNodes', params?.excludeGroupNodesWithoutPageChildNodes);
  }
  if (params?.temporalCheck) {
    formData.append('temporalCheck', params?.temporalCheck);
  }
  if (params?.visibility) {
    params.visibility.forEach(visibility => {
      formData.append('visibility', visibility);
    });
  }
  const dataParams = new URLSearchParams(formData).toString();

  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/social/sites/${siteId}?${dataParams}`, {
    method: 'GET',
    credentials: 'include',
  }).then(resp => {
    if (resp?.ok) {
      return resp.json();
    } else {
      throw new Error('Error while getting site by id');
    }
  });
}