/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ExtendProfileFilter;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.model.Attachment;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RDBMSIdentityStorageImpl
implements IdentityStorage {
    private static final char NULL_CHARACTER = '\u0000';
    private static final Log LOG;
    private static final int BATCH_SIZE = 100;
    private static final long MEGABYTE = 0x100000L;
    private static final String socialNameSpace = "social";
    private final IdentityDAO identityDAO;
    private final SpaceMemberDAO spaceMemberDAO;
    private final FileService fileService;
    private final OrganizationService orgService;
    private ProfileSearchConnector profileSearchConnector;
    private IdentityStorage cachedIdentityStorage;
    private ActivityStorage activityStorage;
    private Map<String, IdentityProvider<?>> identityProviders = null;
    private int imageUploadLimit = 2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RDBMSIdentityStorageImpl(IdentityDAO identityDAO, SpaceMemberDAO spaceMemberDAO, FileService fileService, OrganizationService orgService) {
        this.identityDAO = identityDAO;
        this.spaceMemberDAO = spaceMemberDAO;
        this.orgService = orgService;
        this.fileService = fileService;
    }

    private IdentityDAO getIdentityDAO() {
        return this.identityDAO;
    }

    public ProfileSearchConnector getProfileSearchConnector() {
        if (this.profileSearchConnector == null) {
            this.profileSearchConnector = (ProfileSearchConnector)CommonsUtils.getService(ProfileSearchConnector.class);
        }
        return this.profileSearchConnector;
    }

    public void setProfileSearchConnector(ProfileSearchConnector profileSearchConnector) {
        this.profileSearchConnector = profileSearchConnector;
    }

    private void mapToProfileEntity(Profile profile, IdentityEntity identityEntity) {
        String providerId;
        Map<String, String> entityProperties = identityEntity.getProperties();
        if (entityProperties == null) {
            entityProperties = new HashMap<String, String>();
        }
        if (!"organization".equals(providerId = profile.getIdentity().getProviderId()) && !"space".equals(providerId)) {
            entityProperties.put("Url", profile.getUrl());
        }
        boolean hasBanner = false;
        boolean hasAvatar = false;
        Map<String, Object> properties = profile.getProperties();
        for (Map.Entry<String, Object> profileProperty : properties.entrySet()) {
            FileItem fileItem;
            String fileName;
            Object bytes;
            Attachment attachment;
            if ("avatar".equalsIgnoreCase(profileProperty.getKey())) {
                hasAvatar = true;
                attachment = (AvatarAttachment)profileProperty.getValue();
                bytes = attachment.getImageBytes();
                if (bytes == null || ((byte[])bytes).length == 0) continue;
                if ((long)((byte[])bytes).length / 0x100000L > (long)this.imageUploadLimit) {
                    throw new IdentityStorageException(IdentityStorageException.Type.AVATAR_EXCEEDS_LIMIT);
                }
                fileName = attachment.getFileName();
                if (fileName == null) {
                    fileName = identityEntity.getRemoteId() + "_avatar";
                }
                try {
                    Long avatarId = identityEntity.getAvatarFileId();
                    if (avatarId != null) {
                        fileItem = new FileItem(avatarId, fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                        this.fileService.updateFile(fileItem);
                        continue;
                    }
                    fileItem = new FileItem(null, fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                    fileItem = this.fileService.writeFile(fileItem);
                    identityEntity.setAvatarFileId(fileItem.getFileInfo().getId());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Can not store avatar for " + identityEntity.getProviderId() + " " + identityEntity.getRemoteId()), (Throwable)ex);
                }
                continue;
            }
            if ("banner".equalsIgnoreCase(profileProperty.getKey())) {
                hasBanner = true;
                attachment = (BannerAttachment)profileProperty.getValue();
                bytes = attachment.getImageBytes();
                if (bytes == null || ((byte[])bytes).length == 0) continue;
                if ((long)((byte[])bytes).length / 0x100000L > (long)this.imageUploadLimit) {
                    throw new IdentityStorageException(IdentityStorageException.Type.BANNER_EXCEEDS_LIMIT);
                }
                fileName = attachment.getFileName();
                if (fileName == null) {
                    fileName = identityEntity.getRemoteId() + "_banner";
                }
                try {
                    Long bannerId = identityEntity.getBannerFileId();
                    if (bannerId != null) {
                        fileItem = new FileItem(bannerId, fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                        this.fileService.updateFile(fileItem);
                        continue;
                    }
                    fileItem = new FileItem(null, fileName, attachment.getMimeType(), socialNameSpace, (long)((Object)bytes).length, new Date(), identityEntity.getRemoteId(), false, (InputStream)new ByteArrayInputStream((byte[])bytes));
                    fileItem = this.fileService.writeFile(fileItem);
                    identityEntity.setBannerFileId(fileItem.getFileInfo().getId());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Can not store banner for " + identityEntity.getProviderId() + " " + identityEntity.getRemoteId()), (Throwable)ex);
                }
                continue;
            }
            if ("experiences".equalsIgnoreCase(profileProperty.getKey())) {
                List newExperiences = (List)profileProperty.getValue();
                identityEntity.getExperiences().clear();
                bytes = newExperiences.iterator();
                while (bytes.hasNext()) {
                    Map newExperience = (Map)bytes.next();
                    ProfileExperienceEntity profileExperienceEntity = new ProfileExperienceEntity();
                    profileExperienceEntity.setIdentity(identityEntity);
                    String experienceId = (String)newExperience.get("id");
                    if (StringUtils.isNotBlank((String)experienceId)) {
                        profileExperienceEntity.setId(Long.valueOf(experienceId));
                    }
                    profileExperienceEntity.setCompany((String)newExperience.get("company"));
                    profileExperienceEntity.setPosition((String)newExperience.get("position"));
                    profileExperienceEntity.setStartDate((String)newExperience.get("startDate"));
                    profileExperienceEntity.setEndDate((String)newExperience.get("endDate"));
                    profileExperienceEntity.setSkills((String)newExperience.get("skills"));
                    profileExperienceEntity.setDescription((String)newExperience.get("description"));
                    identityEntity.getExperiences().add(profileExperienceEntity);
                }
                continue;
            }
            if ("ims".equals(profileProperty.getKey()) || "phones".equals(profileProperty.getKey()) || "urls".equals(profileProperty.getKey())) {
                List list = (List)profileProperty.getValue();
                JSONArray arr = new JSONArray();
                for (Map map : list) {
                    JSONObject json = new JSONObject(map);
                    arr.put((Object)json);
                }
                entityProperties.put(profileProperty.getKey(), arr.toString());
                continue;
            }
            if ("skills".equals(profileProperty.getKey())) continue;
            Object val = profileProperty.getValue();
            entityProperties.put(profileProperty.getKey(), val != null ? String.valueOf(val) : null);
        }
        if (identityEntity.getBannerFileId() != null && !hasBanner && profile.getBannerUrl() == null) {
            this.fileService.deleteFile(identityEntity.getBannerFileId().longValue());
            identityEntity.setBannerFileId(null);
        }
        if (identityEntity.getAvatarFileId() != null && !hasAvatar && profile.getAvatarUrl() == null) {
            this.fileService.deleteFile(identityEntity.getAvatarFileId().longValue());
            identityEntity.setAvatarFileId(null);
        }
        identityEntity.setProperties(entityProperties);
        Date created = profile.getCreatedTime() <= 0L ? new Date() : new Date(profile.getCreatedTime());
        identityEntity.setCreatedDate(created);
    }

    @Override
    public void saveIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        entity = id > 0L ? (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id)) : this.getIdentityDAO().findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            entity = new IdentityEntity();
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        if (entity.getId() > 0L) {
            this.getIdentityDAO().update(entity);
        } else {
            if (identity.getProfile() != null) {
                this.mapToProfileEntity(identity.getProfile(), entity);
            }
            entity = (IdentityEntity)this.getIdentityDAO().create(entity);
        }
        Profile profile = EntityConverterUtils.convertToProfile(entity, identity);
        if (id <= 0L) {
            profile.setId(null);
        }
        identity.setProfile(profile);
        identity.setId(entity.getStringId());
    }

    @Override
    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = null;
        if (id > 0L) {
            entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        }
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_IDENTITY, "The identity does not exist on DB");
        }
        EntityConverterUtils.mapToEntity(identity, entity);
        entity = (IdentityEntity)this.getIdentityDAO().update(entity);
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    @Override
    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
    }

    @Override
    public Identity findIdentityById(String nodeId) throws IdentityStorageException {
        long id = EntityConverterUtils.parseId(nodeId);
        IdentityEntity entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            return EntityConverterUtils.convertToIdentity(entity);
        }
        return null;
    }

    @Override
    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.hardDeleteIdentity(identity);
    }

    @Override
    @ExoTransactional
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        Profile profile2 = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)profile2);
        Object[] objectArray = new Object[]{this, profile2, joinPoint};
        return (Profile)ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        try {
            IdentityEntity entity = this.getIdentityDAO().findByProviderAndRemoteId(providerId, remoteId);
            if (entity == null) {
                return null;
            }
            return EntityConverterUtils.convertToIdentity(entity);
        }
        catch (Exception ex) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY, "Can not load identity", ex);
        }
    }

    @Override
    public void saveProfile(Profile profile) throws IdentityStorageException {
        IdentityEntity entity;
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity identityEntity = entity = id == 0L ? null : (IdentityEntity)this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        this.mapToProfileEntity(profile, entity);
        this.identityDAO.update(entity);
        profile.setId(entity.getStringId());
        profile.clearHasChanged();
    }

    @Override
    @ExoTransactional
    public void updateProfile(Profile profile) throws IdentityStorageException {
        Profile profile2 = profile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)profile2);
        Object[] objectArray = new Object[]{this, profile2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return (int)this.getIdentityDAO().countIdentityByProvider(providerId);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.updateProfile(profile);
    }

    @Override
    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
    }

    @Override
    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        String t = "SPACE_ACTIVITY";
        if (type == Profile.AttachedActivityType.USER) {
            t = "USER_PROFILE_ACTIVITY";
        } else if (type == Profile.AttachedActivityType.RELATIONSHIP) {
            t = "USER_ACTIVITIES_FOR_RELATIONSHIP";
        }
        List<ExoSocialActivity> activitiesByPoster = this.getActivityStorage().getActivitiesByPoster(profile.getIdentity(), 0, 1, t);
        if (activitiesByPoster != null && activitiesByPoster.size() > 0) {
            return String.valueOf(activitiesByPoster.get(0).getId());
        }
        return null;
    }

    @Override
    public Set<String> getActiveUsers(ActiveIdentityFilter filter) {
        HashSet<String> activeUsers = new HashSet();
        if (filter.getUserGroups() != null) {
            StringTokenizer stringToken = new StringTokenizer(filter.getUserGroups(), ",");
            try {
                while (stringToken.hasMoreTokens()) {
                    try {
                        User[] users;
                        ListAccess listAccess = this.orgService.getUserHandler().findUsersByGroupId(stringToken.nextToken().trim());
                        for (User u : users = (User[])listAccess.load(0, listAccess.getSize())) {
                            activeUsers.add(u.getUserName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
        if (filter.getDays() > 0) {
            activeUsers = StorageUtils.getLastLogin(filter.getDays());
        }
        if (CommonsUtils.getService(UserStateService.class) != null) {
            List onlines = ((UserStateService)CommonsUtils.getService(UserStateService.class)).online();
            for (UserStateModel user : onlines) {
                activeUsers.add(user.getUserId());
            }
        }
        return activeUsers;
    }

    @Override
    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        long id = EntityConverterUtils.parseId(identity.getId());
        IdentityEntity entity = (IdentityEntity)this.getIdentityDAO().find(Long.valueOf(id));
        if (entity == null) {
            throw new IllegalArgumentException("Identity does not exists");
        }
        entity.setEnabled(isEnable);
        this.getIdentityDAO().update(entity);
    }

    @Override
    public List<Identity> getIdentitiesByFirstCharacterOfName(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
    }

    @Override
    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        Identity identity = null;
        if (profileFilter.getViewerIdentity() != null) {
            identity = profileFilter.getViewerIdentity();
        }
        if ("organization".equals(providerId)) {
            return this.getProfileSearchConnector().search(identity, profileFilter, type, offset, limit);
        }
        throw new IllegalStateException("Can't search identities with provider id = " + providerId);
    }

    @Override
    public int getIdentitiesForMentionsCount(String providerId, ProfileFilter profileFilter, Relationship.Type type) throws IdentityStorageException {
        Identity identity = null;
        if (profileFilter.getViewerIdentity() != null) {
            identity = profileFilter.getViewerIdentity();
        }
        if ("organization".equals(providerId)) {
            return this.getProfileSearchConnector().count(identity, profileFilter, type);
        }
        throw new IllegalStateException("Can't search identities with provider id = " + providerId);
    }

    @Override
    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        try {
            return list.getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getIdentitiesByFirstCharacterOfNameCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        try {
            return list.getSize();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.getProfileSearchConnector().search(null, profileFilter, null, offset, limit);
    }

    @Override
    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        if (space == null) {
            throw new IllegalArgumentException("Space shouldn't be null");
        }
        String firstCharFieldName = profileFilter.getFirstCharFieldName();
        char firstCharacter = profileFilter.getFirstCharacterOfName();
        Sorting sorting = profileFilter.getSorting();
        String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
        String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
        ArrayList<String> excludedMembers = new ArrayList<String>();
        if (profileFilter != null && profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                excludedMembers.add(identity.getRemoteId());
            }
        }
        SpaceMemberEntity.Status status = null;
        switch (type) {
            case MANAGER: {
                status = SpaceMemberEntity.Status.MANAGER;
                break;
            }
            case INVITED: {
                status = SpaceMemberEntity.Status.INVITED;
                break;
            }
            case PENDING: {
                status = SpaceMemberEntity.Status.PENDING;
                break;
            }
            default: {
                status = SpaceMemberEntity.Status.MEMBER;
            }
        }
        List<String> spaceMembers = this.getSpaceMembers(space.getId(), status);
        if (spaceMembers == null || spaceMembers.isEmpty()) {
            return Collections.emptyList();
        }
        spaceMembers = spaceMembers.stream().filter(username -> !excludedMembers.contains(username)).collect(Collectors.toList());
        if (profileFilter != null && profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                spaceMembers.remove(identity.getRemoteId());
            }
        }
        if (profileFilter == null || profileFilter.isEmpty()) {
            ArrayList<Identity> identities = new ArrayList<Identity>();
            spaceMembers = this.sortIdentities(spaceMembers, firstCharFieldName, firstCharacter, sortFieldName, sortDirection, false);
            int i = (int)offset;
            long indexLimit = offset + limit;
            while (i < spaceMembers.size() && (long)i < indexLimit) {
                String spaceMemberUserName;
                Identity identity;
                if ((identity = this.getOrCreateUserIdentityUsingCache("organization", spaceMemberUserName = spaceMembers.get(i++))) == null) continue;
                identities.add(identity);
            }
            return identities;
        }
        try {
            profileFilter = profileFilter.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Object)"Error while cloning profile filter", (Throwable)e);
        }
        profileFilter.setRemoteIds(spaceMembers);
        return this.getProfileSearchConnector().search(null, profileFilter, null, offset, limit);
    }

    @Override
    public int countSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type) {
        if (space == null) {
            throw new IllegalArgumentException("Space shouldn't be null");
        }
        ArrayList<String> excludedMembers = new ArrayList<String>();
        if (profileFilter != null && profileFilter.getExcludedIdentityList() != null) {
            for (Identity identity : profileFilter.getExcludedIdentityList()) {
                excludedMembers.add(identity.getRemoteId());
            }
        }
        List<String> spaceMembers = null;
        switch (type) {
            case INVITED: {
                if (space.getInvitedUsers() == null || space.getInvitedUsers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getInvitedUsers()).filter(username -> !excludedMembers.contains(username)).collect(Collectors.toList());
                break;
            }
            case PENDING: {
                if (space.getPendingUsers() == null || space.getPendingUsers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getPendingUsers()).filter(username -> !excludedMembers.contains(username)).collect(Collectors.toList());
                break;
            }
            case MANAGER: {
                if (space.getManagers() == null || space.getManagers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getManagers()).filter(username -> !excludedMembers.contains(username)).collect(Collectors.toList());
                break;
            }
            default: {
                if (space.getMembers() == null || space.getMembers().length == 0) {
                    return 0;
                }
                spaceMembers = Arrays.stream(space.getMembers()).filter(username -> !excludedMembers.contains(username)).collect(Collectors.toList());
            }
        }
        if (profileFilter == null || profileFilter.isEmpty()) {
            return spaceMembers.size();
        }
        try {
            profileFilter = profileFilter.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Object)"Error while cloning profile filter", (Throwable)e);
        }
        profileFilter.setRemoteIds(spaceMembers);
        return this.getProfileSearchConnector().count(null, profileFilter, null);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setProviderId(providerId);
        xFilter.setForceLoadProfile(forceLoadOrReloadProfile);
        ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(xFilter);
        return EntityConverterUtils.convertToIdentities(list, offset, limit);
    }

    @Override
    public List<Identity> getIdentities(String providerId, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, long offset, long limit) {
        List<String> usernames = this.getIdentityDAO().getAllIdsByProviderSorted(providerId, firstCharacterFieldName, firstCharacter, sortField, sortDirection, offset, limit);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (usernames != null && !usernames.isEmpty()) {
            for (String username : usernames) {
                Identity identity = this.getOrCreateUserIdentityUsingCache(providerId, username);
                if (identity == null) continue;
                identities.add(identity);
            }
        }
        return identities;
    }

    @Override
    public List<Identity> getIdentities(String providerId, long offset, long limit) throws IdentityStorageException {
        return this.getIdentities(providerId, null, '\u0000', null, null, offset, limit);
    }

    @Override
    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) throws IdentityStorageException {
        return this.getIdentitiesWithRelationships(identityId, null, '\u0000', null, null, offset, limit);
    }

    @Override
    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, String firstCharFieldName, char firstChar, String sortFieldName, String sortDirection, int offset, int limit) {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId), firstCharFieldName, firstChar, sortFieldName, sortDirection);
        return EntityConverterUtils.convertToIdentitiesWithRelationship(list, offset, limit);
    }

    @Override
    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list = this.getIdentityDAO().findAllIdentitiesWithConnections(Long.valueOf(identityId), null, '\u0000', null, null);
        return list.getSize();
    }

    public ListAccess<Identity> findByFilter(ExtendProfileFilter filter) {
        final ListAccess<IdentityEntity> list = this.getIdentityDAO().findIdentities(filter);
        return new ListAccess<Identity>(){

            public Identity[] load(int offset, int size) throws Exception, IllegalArgumentException {
                IdentityEntity[] entities = (IdentityEntity[])list.load(offset, size);
                if (entities == null || entities.length == 0) {
                    return new Identity[0];
                }
                Identity[] identities = new Identity[entities.length];
                for (int i = 0; i < entities.length; ++i) {
                    identities[i] = EntityConverterUtils.convertToIdentity(entities[i]);
                }
                return identities;
            }

            public int getSize() throws Exception {
                return list.getSize();
            }
        };
    }

    @ExoTransactional
    public void removeIdentity(Identity identity) {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSIdentityStorageImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public InputStream getAvatarInputStreamById(Identity identity) throws IOException {
        FileItem file = null;
        IdentityEntity entity = this.identityDAO.findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            return null;
        }
        Long avatarId = entity.getAvatarFileId();
        if (avatarId == null) {
            return null;
        }
        try {
            file = this.fileService.getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    @Override
    public InputStream getBannerInputStreamById(Identity identity) throws IOException {
        FileItem file = null;
        IdentityEntity entity = this.identityDAO.findByProviderAndRemoteId(identity.getProviderId(), identity.getRemoteId());
        if (entity == null) {
            return null;
        }
        Long bannerId = entity.getBannerFileId();
        if (bannerId == null) {
            return null;
        }
        try {
            file = this.fileService.getFile(bannerId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    private List<String> getSpaceMembers(String spaceIdString, SpaceMemberEntity.Status status) {
        long spaceId = Long.parseLong(spaceIdString);
        int countSpaceMembers = this.spaceMemberDAO.countSpaceMembers(spaceId, status);
        if (countSpaceMembers == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> members = new ArrayList<String>();
        for (int offset = 0; offset < countSpaceMembers; offset += 100) {
            List<String> spaceMembers = this.spaceMemberDAO.getSpaceMembers(spaceId, status, offset, 100);
            for (String username : spaceMembers) {
                members.add(username);
            }
        }
        return members;
    }

    public IdentityProvider<?> getIdentityProvider(String providerId) {
        if (this.identityProviders == null || this.identityProviders.isEmpty()) {
            this.identityProviders = new HashMap();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container == null) {
                container = PortalContainer.getInstance();
            }
            for (ComponentAdapter componentAdapter : container.getComponentAdaptersOfType(IdentityProvider.class)) {
                if (componentAdapter == null) continue;
                Object key = componentAdapter.getComponentKey();
                IdentityProvider service = (IdentityProvider)container.getComponentInstance(key);
                this.identityProviders.put(service.getName(), service);
            }
        }
        return this.identityProviders.get(providerId);
    }

    public IdentityStorage getRDBMSCachedIdentityStorage() {
        if (this.cachedIdentityStorage == null) {
            this.cachedIdentityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        }
        return this.cachedIdentityStorage;
    }

    public ActivityStorage getActivityStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)CommonsUtils.getService(ActivityStorage.class);
        }
        return this.activityStorage;
    }

    private Identity getOrCreateUserIdentityUsingCache(String providerId, String userId) {
        Identity identity = this.getRDBMSCachedIdentityStorage().findIdentity(providerId, userId);
        if (identity == null) {
            identity = this.getIdentityProvider(providerId).getIdentityByRemoteId(userId);
            if (identity == null) {
                LOG.warn("Can't find identity for space member '{}'. The identity will not be retrieved.", new Object[]{userId});
            } else {
                LOG.info("User identity for space member '{}' wasn't found. Creating the identity.", new Object[]{userId});
                try {
                    this.saveIdentity(identity);
                    this.saveProfile(identity.getProfile());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Can't create user identity for space member '" + userId + "'. The identity will not be retrieved."), (Throwable)e);
                    identity = null;
                }
            }
        }
        return identity;
    }

    @Override
    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        return this.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection, true);
    }

    @Override
    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, boolean filterDisabled) {
        return this.spaceMemberDAO.sortSpaceMembers(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection, filterDisabled);
    }

    @Override
    public void setImageUploadLimit(int imageUploadLimit) {
        this.imageUploadLimit = imageUploadLimit;
    }

    static {
        RDBMSIdentityStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSIdentityStorageImpl.class);
    }

    static /* synthetic */ void hardDeleteIdentity_aroundBody0(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        if (entity != null) {
            entity.setDeleted(true);
            ajc$this.getIdentityDAO().update(entity);
            if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
                ajc$this.fileService.deleteFile(entity.getAvatarFileId().longValue());
            }
            if (entity.getBannerFileId() != null && entity.getBannerFileId() > 0L) {
                ajc$this.fileService.deleteFile(entity.getBannerFileId().longValue());
            }
        }
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
    }

    static /* synthetic */ Profile loadProfile_aroundBody2(RDBMSIdentityStorageImpl ajc$this, Profile profile, JoinPoint joinPoint) {
        long identityId = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(identityId));
        if (entity == null) {
            return null;
        }
        profile.setId(String.valueOf(entity.getId()));
        EntityConverterUtils.mapToProfile(entity, profile);
        profile.clearHasChanged();
        return profile;
    }

    static /* synthetic */ void updateProfile_aroundBody4(RDBMSIdentityStorageImpl ajc$this, Profile profile, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(profile.getIdentity().getId());
        IdentityEntity entity = (IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(id));
        if (entity == null) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_UPDATE_PROFILE, "Profile does not exist on RDBMS");
        }
        ajc$this.mapToProfileEntity(profile, entity);
        ajc$this.identityDAO.update(entity);
    }

    static /* synthetic */ void removeIdentity_aroundBody6(RDBMSIdentityStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        long id = EntityConverterUtils.parseId(identity.getId());
        String username = identity.getRemoteId();
        String provider = identity.getProviderId();
        IdentityEntity entity = (IdentityEntity)ajc$this.getIdentityDAO().find(Long.valueOf(id));
        EntityManager em = ((EntityManagerService)CommonsUtils.getService(EntityManagerService.class)).getEntityManager();
        Query query = em.createNamedQuery("SocConnection.deleteConnectionByIdentity");
        query.setParameter("identityId", (Object)id);
        query.executeUpdate();
        if ("organization".equals(provider)) {
            query = em.createNamedQuery("SpaceMember.deleteByUsername");
            query.setParameter("username", (Object)username);
            query.executeUpdate();
        }
        if (entity != null) {
            ajc$this.getIdentityDAO().delete(entity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSIdentityStorageImpl.java", RDBMSIdentityStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hardDeleteIdentity", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "org.exoplatform.social.core.storage.IdentityStorageException", "void"), 427);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadProfile", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Profile", "profile", "org.exoplatform.social.core.storage.IdentityStorageException", "org.exoplatform.social.core.identity.model.Profile"), 468);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateProfile", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Profile", "profile", "org.exoplatform.social.core.storage.IdentityStorageException", "void"), 533);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeIdentity", "org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "", "void"), 962);
    }
}

