/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;

public class PartitionerConsistentHash
implements ConsistentHash {
    private final ConsistentHash ch;
    private final KeyPartitioner keyPartitioner;

    public PartitionerConsistentHash(ConsistentHash ch, KeyPartitioner keyPartitioner) {
        this.ch = Objects.requireNonNull(ch);
        this.keyPartitioner = Objects.requireNonNull(keyPartitioner);
    }

    @Override
    public int getNumSegments() {
        return this.ch.getNumSegments();
    }

    @Override
    public int getNumOwners() {
        return this.ch.getNumOwners();
    }

    @Override
    public List<Address> getMembers() {
        return this.ch.getMembers();
    }

    @Override
    public int getSegment(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.ch.locateOwnersForSegment(segmentId);
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.ch.locatePrimaryOwnerForSegment(segmentId);
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.ch.isSegmentLocalToNode(nodeAddress, segmentId);
    }

    @Override
    public boolean isReplicated() {
        return this.ch.isReplicated();
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        return this.ch.getSegmentsForOwner(owner);
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        return this.ch.getPrimarySegmentsForOwner(owner);
    }

    @Override
    public String getRoutingTableAsString() {
        return this.ch.getRoutingTableAsString();
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        int segment = this.ch.isReplicated() ? 0 : this.getSegment(key);
        return this.ch.isSegmentLocalToNode(nodeAddress, segment);
    }

    @Override
    public Hash getHashFunction() {
        return this.ch.getHashFunction();
    }

    public KeyPartitioner getKeyPartitioner() {
        return this.keyPartitioner;
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        this.ch.toScopedState(state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionerConsistentHash that = (PartitionerConsistentHash)o;
        if (!this.ch.equals(that.ch)) {
            return false;
        }
        return this.keyPartitioner.equals(that.keyPartitioner);
    }

    public int hashCode() {
        int result = this.ch.hashCode();
        result = 31 * result + this.keyPartitioner.hashCode();
        return result;
    }

    public String toString() {
        return "PartitionerConsistentHash:" + this.ch;
    }
}

