/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreImpl;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class ExoHibernateIdentityStoreSessionImpl
implements IdentityStoreSession {
    private static Logger log = Logger.getLogger(HibernateIdentityStoreImpl.class.getName());
    private final SessionFactory sessionFactory;
    private final boolean lazyStartOfHibernateTransaction;
    private final ThreadLocal<Boolean> hibernateTxStatus = new ThreadLocal();

    public ExoHibernateIdentityStoreSessionImpl(SessionFactory sessionFactory, boolean lazyStartOfHibernateTransaction) {
        this.sessionFactory = sessionFactory;
        this.lazyStartOfHibernateTransaction = lazyStartOfHibernateTransaction;
    }

    public Object getSessionContext() {
        return this.sessionFactory.getCurrentSession();
    }

    public void close() throws IdentityException {
        this.sessionFactory.getCurrentSession().close();
    }

    public void save() throws IdentityException {
        Boolean flushNeeded = !this.lazyStartOfHibernateTransaction;
        if (!flushNeeded.booleanValue()) {
            Boolean txStatus = this.hibernateTxStatus.get();
            flushNeeded = txStatus != null && txStatus != false;
        }
        if (flushNeeded.booleanValue()) {
            this.sessionFactory.getCurrentSession().flush();
        }
    }

    public void clear() throws IdentityException {
        Boolean clearNeeded = !this.lazyStartOfHibernateTransaction;
        if (!clearNeeded.booleanValue()) {
            Boolean txStatus = this.hibernateTxStatus.get();
            clearNeeded = txStatus != null && txStatus != false;
        }
        if (clearNeeded.booleanValue()) {
            this.sessionFactory.getCurrentSession().clear();
        }
    }

    public boolean isOpen() {
        return this.sessionFactory.getCurrentSession().isOpen();
    }

    public boolean isTransactionSupported() {
        return true;
    }

    public void startTransaction() {
        if (this.lazyStartOfHibernateTransaction) {
            if (this.hibernateTxStatus.get() == null) {
                this.hibernateTxStatus.set(Boolean.FALSE);
            }
        } else {
            this.startHibernateTransaction();
        }
    }

    public void commitTransaction() {
        if (this.lazyStartOfHibernateTransaction) {
            Boolean hbTxStatus = this.hibernateTxStatus.get();
            if (hbTxStatus != null && hbTxStatus.booleanValue()) {
                try {
                    this.commitHibernateTransaction();
                }
                finally {
                    this.hibernateTxStatus.set(null);
                }
            }
        } else {
            this.commitHibernateTransaction();
        }
    }

    public void rollbackTransaction() {
        if (this.lazyStartOfHibernateTransaction) {
            Boolean hbTxStatus = this.hibernateTxStatus.get();
            if (hbTxStatus != null && hbTxStatus.booleanValue()) {
                try {
                    this.rollbackHibernateTransaction();
                }
                finally {
                    this.hibernateTxStatus.set(null);
                }
            }
        } else {
            this.rollbackHibernateTransaction();
        }
    }

    public boolean isTransactionActive() {
        if (this.lazyStartOfHibernateTransaction) {
            return this.hibernateTxStatus.get() != null && this.hibernateTxStatus.get() != false;
        }
        return this.isHibernateTransactionActive();
    }

    void startHibernateTransactionIfNotStartedYet() {
        Boolean txStatus = this.hibernateTxStatus.get();
        if (txStatus == null || !txStatus.booleanValue()) {
            this.startHibernateTransaction();
            this.hibernateTxStatus.set(Boolean.TRUE);
        }
    }

    private void startHibernateTransaction() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Going to start Hibernate transaction");
        }
        this.sessionFactory.getCurrentSession().getTransaction().begin();
    }

    private void commitHibernateTransaction() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Going to commit Hibernate transaction");
        }
        this.sessionFactory.getCurrentSession().getTransaction().commit();
    }

    private void rollbackHibernateTransaction() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Going to rollback Hibernate transaction");
        }
        this.sessionFactory.getCurrentSession().getTransaction().rollback();
    }

    private boolean isHibernateTransactionActive() {
        return this.sessionFactory.getCurrentSession().getTransaction().isActive();
    }

    Boolean getHibernateTxStatus() {
        return this.hibernateTxStatus.get();
    }
}

