/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.service.GettingStartedService;

@Path(value="getting-started")
@RolesAllowed(value={"users"})
@Api(value="/getting-started", description="Check getting Started steps for currently authenticated user")
public class GettingStartedRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GettingStartedRestService.class);
    private GettingStartedService gettingStartedService;

    public GettingStartedRestService(GettingStartedService gettingStartedService) {
        this.gettingStartedService = gettingStartedService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Collect Getting Started Steps", httpMethod="GET", response=Response.class, produces="application/json", notes="Return getting started steps in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getGettingStartedSteps() {
        ConversationState current = ConversationState.getCurrent();
        try {
            List gettinStartedSteps = this.gettingStartedService.getUserSteps(current.getIdentity().getUserId());
            return Response.ok((Object)gettinStartedSteps).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Unknown error occurred while getting user steps", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

