/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.List;
import javax.annotation.Nullable;
import org.owasp.html.JoinedElementPolicy;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
public interface ElementPolicy {
    public static final ElementPolicy IDENTITY_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        public String apply(String elementName, List<String> attrs) {
            return elementName;
        }
    };
    public static final ElementPolicy REJECT_ALL_ELEMENT_POLICY = new ElementPolicy(){

        @Override
        @Nullable
        public String apply(String elementName, List<String> attrs) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, List<String> var2);

    public static final class Util {
        private Util() {
        }

        public static final ElementPolicy join(ElementPolicy ... policies) {
            class PolicyJoiner {
                ElementPolicy last = null;
                ElementPolicy out = null;

                PolicyJoiner() {
                }

                void join(ElementPolicy p) {
                    if (p == REJECT_ALL_ELEMENT_POLICY) {
                        this.out = p;
                    } else if (this.out != REJECT_ALL_ELEMENT_POLICY) {
                        if (p instanceof JoinedElementPolicy) {
                            JoinedElementPolicy jep = (JoinedElementPolicy)p;
                            this.join(jep.first);
                            this.join(jep.second);
                        } else if (p != this.last) {
                            this.last = p;
                            if (this.out == null || this.out == IDENTITY_ELEMENT_POLICY) {
                                this.out = p;
                            } else if (p != IDENTITY_ELEMENT_POLICY) {
                                this.out = new JoinedElementPolicy(this.out, p);
                            }
                        }
                    }
                }
            }
            PolicyJoiner pu = new PolicyJoiner();
            for (ElementPolicy policy : policies) {
                if (policy == null) continue;
                pu.join(policy);
            }
            return pu.out != null ? pu.out : IDENTITY_ELEMENT_POLICY;
        }
    }
}

