/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;

public class StringListAccess
implements ListAccess<String> {
    private final List<String> list;

    public StringListAccess(List<String> list) {
        this.list = list;
    }

    public String[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        if (index + length > this.list.size()) {
            throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
        }
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.list.get(i + index);
        }
        return result;
    }

    public int getSize() throws Exception {
        return this.list.size();
    }
}

