/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.account.UIAccountSetting;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortal.gtmpl", events={@EventConfig(listeners={UIPortalComponentActionListener.ChangeApplicationListActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}, csrfCheck=false), @EventConfig(listeners={LogoutActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.ShowLoginFormActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.ChangeLanguageActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.EditPortalPropertiesActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.ChangeSkinActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.RecoveryPasswordAndUsernameActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalActionListener.PingActionListener.class}, csrfCheck=false)})
public class UIPortal
extends UIContainer {
    private SiteKey siteKey;
    private String locale;
    private String label;
    private String description;
    private String editPermission;
    private String skin;
    private Properties properties;
    private UserNode navPath;
    private Map<String, UIPage> all_UIPages;
    private Map<String, String[]> publicParameters_ = new HashMap<String, String[]>();
    private UIComponent maximizedUIComponent;
    private ArrayList<PortalRedirect> portalRedirects;
    private boolean useDynamicLayout;

    public boolean isUseDynamicLayout() {
        return this.useDynamicLayout;
    }

    public void setUseDynamicLayout(Boolean useDynamicLayout) {
        this.useDynamicLayout = useDynamicLayout;
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(SiteKey key) {
        this.siteKey = key;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    @Deprecated
    public String getOwnerType() {
        return this.siteKey.getTypeName();
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters_;
    }

    public void setPublicParameters(Map<String, String[]> publicParams) {
        this.publicParameters_ = publicParams;
    }

    public UserNode getNavPath() {
        if (this.navPath == null) {
            PortalRequestContext prc = Util.getPortalRequestContext();
            this.navPath = prc.getUserPortalConfig().getUserPortal().getDefaultPath(null);
        }
        return this.navPath;
    }

    public void setNavPath(UserNode nav) {
        this.navPath = nav;
    }

    public UIPage getUIPage(String pageReference) {
        if (this.all_UIPages == null) {
            return null;
        }
        return this.all_UIPages.get(pageReference);
    }

    public void setUIPage(String pageReference, UIPage uiPage) {
        if (this.all_UIPages == null) {
            this.all_UIPages = new HashMap<String, UIPage>(5);
        }
        this.all_UIPages.put(pageReference, uiPage);
    }

    public void clearUIPage(String pageReference) {
        if (this.all_UIPages != null) {
            this.all_UIPages.remove(pageReference);
        }
    }

    public UserNavigation getUserNavigation() {
        PortalRequestContext prc = Util.getPortalRequestContext();
        return prc.getUserPortalConfig().getUserPortal().getNavigation(this.siteKey);
    }

    public void refreshUIPage() throws Exception {
        UIPageBody uiPageBody = (UIPageBody)this.findFirstComponentOfType(UIPageBody.class);
        if (uiPageBody == null) {
            return;
        }
        uiPageBody.setPageBody(this.getSelectedUserNode(), this);
    }

    public UserNode getSelectedUserNode() throws Exception {
        return this.getNavPath();
    }

    public UIComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIComponent maximizedReferenceComponent) {
        this.maximizedUIComponent = maximizedReferenceComponent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, null);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    public Boolean isShowInfobar() {
        String value = this.getProperty("showPortletInfo", "1");
        if (Integer.parseInt(value) == 1) {
            return true;
        }
        return false;
    }

    public void setShowInfobar(Boolean value) {
        if (value.booleanValue()) {
            this.setProperty("showPortletInfo", "1");
        } else {
            this.setProperty("showPortletInfo", "0");
        }
    }

    public String getCacheControl() {
        return this.getProperty("cacheControl");
    }

    public void setCacheControl(String cacheControl) {
        this.setProperty("cacheControl", cacheControl);
    }

    public String getViewport() {
        return this.getProperty("viewport");
    }

    public void setViewport(String viewport) {
        this.setProperty("viewport", viewport);
    }

    public String getSharedLayout() {
        return this.getProperty("sharedLayout", "allUsers");
    }

    public void setSharedLayout(String type) {
        if (type.equals("adminsOnly")) {
            this.setProperty("sharedLayout", "adminsOnly");
        } else {
            this.setProperty("sharedLayout", "allUsers");
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public void setRedirects(ArrayList<PortalRedirect> portalRedirects) {
        this.portalRedirects = portalRedirects;
    }

    public ArrayList<PortalRedirect> getPortalRedirects() {
        return this.portalRedirects;
    }

    @Override
    public String getPermissionClasses() {
        StringBuilder permissionClasses = new StringBuilder();
        if (UIPage.isFullPreviewInPageEditor()) {
            permissionClasses.append(" ProtectedContainer");
        }
        if (!this.hasMoveAppsPermission()) {
            permissionClasses.append(" CannotMoveApps");
        }
        if (!this.hasMoveContainersPermission()) {
            permissionClasses.append(" CannotMoveContainers");
        }
        return permissionClasses.toString();
    }

    public void setHeaderAndFooterRendered(boolean headerAndFooterRendered) {
        List list = this.getChildren();
        for (UIComponent child : list) {
            if (child instanceof UIPageBody || child.isRendered() == headerAndFooterRendered) continue;
            child.setRendered(headerAndFooterRendered);
        }
    }

    public static class AccountSettingsActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            String username = Util.getPortalRequestContext().getRemoteUser();
            OrganizationService service = (OrganizationService)uiPortal.getApplicationComponent(OrganizationService.class);
            User useraccount = service.getUserHandler().findUserByName(username);
            if (useraccount != null) {
                UIAccountSetting uiAccountForm = uiMaskWS.createUIComponent(UIAccountSetting.class, null, null);
                uiMaskWS.setUIComponent((UIComponent)uiAccountForm);
                uiMaskWS.setShow(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            } else {
                JavascriptManager jsManager = Util.getPortalRequestContext().getJavascriptManager();
                jsManager.require("SHARED/base").addScripts("if(confirm('" + Util.getPortalRequestContext().getApplicationResourceBundle().getString("UIAccountProfiles.msg.NotExistingAccount") + "')) {eXo.portal.logout();}");
            }
        }
    }

    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            AbstractTokenService tokenService;
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest req = prContext.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            if ((token = LoginServlet.getOauthRememberMeTokenCookie((HttpServletRequest)req)) != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            LogoutControl.wantLogout();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            prContext.getResponse().addCookie(cookie);
            Cookie oauthCookie = new Cookie("oauth_rememberme", "");
            oauthCookie.setPath(req.getContextPath());
            oauthCookie.setMaxAge(0);
            prContext.getResponse().addCookie(oauthCookie);
            prContext.sendRedirect("/");
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

