/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.compiler;

import java.util.IdentityHashMap;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.PhaseContext;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.template.TagHandler;

public class CompilationPhase {
    private final IdentityHashMap<ASTNode.Tag, TagHandler> tagHandlers = new IdentityHashMap();
    private final PhaseContext context;

    public CompilationPhase(PhaseContext context) {
        this.context = context;
    }

    public TagHandler resolveTagHandler(String name) {
        return this.context.resolveTagHandler(name);
    }

    public TagHandler get(ASTNode.Tag node) {
        return this.tagHandlers.get(node);
    }

    protected void doAttribute(ASTNode<?> node) throws ProcessingException {
        block4: {
            block3: {
                if (!(node instanceof ASTNode.Template)) break block3;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doAttribute(child);
                }
                break block4;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block4;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            TagHandler handler = this.resolveTagHandler(nodeTag.getName());
            if (handler == null) {
                throw TemplateMetaModel.UNKNOWN_TAG.failure(nodeTag.getName());
            }
            this.tagHandlers.put(nodeTag, handler);
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doAttribute(child);
            }
        }
    }

    protected void doUnattribute(ASTNode<?> node) throws ProcessingException {
        block3: {
            block2: {
                if (!(node instanceof ASTNode.Template)) break block2;
                for (ASTNode.Block<?> child : node.getChildren()) {
                    this.doUnattribute(child);
                }
                break block3;
            }
            if (node instanceof ASTNode.Section || node instanceof ASTNode.URL || !(node instanceof ASTNode.Tag)) break block3;
            ASTNode.Tag nodeTag = (ASTNode.Tag)node;
            this.tagHandlers.remove(nodeTag);
            for (ASTNode.Block<?> child : nodeTag.getChildren()) {
                this.doAttribute(child);
            }
        }
    }
}

