/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.model.AvatarAttachment;

public class ImageUtils {
    public static final String KEY_SEPARATOR = "_";
    public static final String KEY_DIMENSION_SEPARATOR = "x";
    public static final String GIF_EXTENDSION = "gif";
    private static final Log LOG = ExoLogger.getLogger(ImageUtils.class);

    private static void makeNotNull(String ... str) {
        for (String string : str) {
            if (string != null) continue;
            string = "";
        }
    }

    public static String buildFileName(String oldFileName, String subfix, String postfix) {
        ImageUtils.makeNotNull(oldFileName, subfix, postfix);
        if (oldFileName.equals("")) {
            return subfix + postfix;
        }
        int dotIndex = oldFileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return subfix + oldFileName + postfix;
        }
        String nameOnly = oldFileName.substring(0, dotIndex);
        String extendtionAndDot = oldFileName.substring(dotIndex);
        return subfix + nameOnly + postfix + extendtionAndDot;
    }

    public static String buildImagePostfix(int width, int height) {
        return KEY_SEPARATOR + (width < 0 ? 0 : width) + KEY_DIMENSION_SEPARATOR + (height < 0 ? 0 : height);
    }

    public static AvatarAttachment createResizedAvatarAttachment(InputStream imageStream, int maxWidth, int maxHeight, String avatarId, String avatarFileName, String avatarMimeType, String avatarWorkspace) {
        if (maxHeight <= 0 || maxWidth <= 0) {
            LOG.warn((Object)"Fail to resize image to avatar attachment with dimension <= 0");
            return null;
        }
        try {
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            String extension = mimeTypeResolver.getExtension(avatarMimeType);
            if (extension.equalsIgnoreCase(GIF_EXTENDSION)) {
                return null;
            }
            BufferedImage image = ImageIO.read(imageStream);
            int targetHeight = image.getHeight();
            int targetWidth = image.getWidth();
            double maxDimensionsRatio = (double)maxHeight / (double)maxWidth;
            double imageRatio = (double)image.getHeight() / (double)image.getWidth();
            if (imageRatio > maxDimensionsRatio && image.getHeight() > maxHeight) {
                targetHeight = maxHeight;
                targetWidth = maxHeight * image.getWidth() / image.getHeight();
            } else if (imageRatio < maxDimensionsRatio && image.getWidth() > maxWidth) {
                targetHeight = maxWidth * image.getHeight() / image.getWidth();
                targetWidth = maxWidth;
            }
            File tmp = File.createTempFile("RESIZED", null);
            image = ImageUtils.resizeImage(image, targetWidth, targetHeight);
            ImageIO.write((RenderedImage)image, extension, tmp);
            AvatarAttachment newAvatarAttachment = new AvatarAttachment(avatarId, avatarFileName, avatarMimeType, new FileInputStream(tmp), System.currentTimeMillis());
            tmp.delete();
            return newAvatarAttachment;
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to resize image to avatar attachment: " + e));
            return null;
        }
    }

    private static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

