/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.navigation.help;

import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;

public class Helper {
    private static final Log LOG = ExoLogger.getExoLogger(Helper.class);
    public static final String DEFAULT_HELP_ID = "default";

    private Helper() {
    }

    public static boolean present(String theString) {
        boolean present = false;
        if (theString != null && theString.length() != 0) {
            present = true;
        }
        return present;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCurrentNavigation(SpaceService spaceService) {
        try {
            String nav = Util.getUIPortal().getNavPath().getName();
            String url = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
            if (url.contains("/:spaces:") || url.contains("/spaces/")) {
                if (url.contains("documents")) {
                    return "space:document";
                }
                if (url.contains("wiki")) {
                    return "space:wiki";
                }
                if (url.contains("tasks")) {
                    return "space:tasks";
                }
                if (url.toLowerCase().contains("answer") || url.contains("faq") || url.contains("poll")) {
                    return "space:faq_annswer";
                }
                if (url.contains("calendar")) {
                    return "space:calendar";
                }
                if (url.contains("forum")) {
                    return "space:forum";
                }
                if (nav.equals("settings")) {
                    return "space:manager";
                }
                String spaceUrl = Helper.getSelectedPageNode().getURI();
                Space space = spaceService.getSpaceByUrl(spaceUrl);
                if (space == null) return DEFAULT_HELP_ID;
                if (!space.getPrettyName().equals(nav)) return DEFAULT_HELP_ID;
                return "space:activity_stream";
            }
            boolean isOwner = Utils.isOwner();
            if (url.contains("wiki") && isOwner) {
                return "personnal:wiki";
            }
            if (url.contains("profile") && isOwner) {
                return "personnal:profile";
            }
            if (url.contains("connections") && isOwner) {
                return "personnal:connections";
            }
            if (url.contains("activities") && isOwner) {
                return "personnal:activities";
            }
            if (url.contains("notifications") && isOwner) {
                return "personnal:notifications";
            }
            if (url.contains("all-spaces")) {
                return "personnal:all-spaces";
            }
            if (nav != null && nav.equals("home")) {
                if (SiteKey.portal((String)Helper.getCurrentPortal()) == null || !SiteKey.portal((String)Helper.getCurrentPortal()).getName().equals("intranet")) return DEFAULT_HELP_ID;
                return "Company Context Home";
            }
            if (nav != null && nav.equals("calendar")) {
                return "Company Context Calendar";
            }
            if (nav != null && nav.equals("forum")) {
                return "Company Context Forum";
            }
            if (nav != null && nav.equals("wiki")) {
                return "Company Context Wiki";
            }
            if (nav != null && nav.equals("tasks")) {
                return "Company Context Tasks";
            }
            if (nav != null && nav.equals("documents")) {
                return "Company Context Documents";
            }
            if (nav != null && (nav.equals("FAQ") || nav.equals("answers"))) {
                return "Company Context FAQ:Answers";
            }
            if (nav == null || !nav.equals("connexions")) return DEFAULT_HELP_ID;
            return "Company Context Connections";
        }
        catch (Exception E) {
            LOG.warn((Object)"Can not load the currentNavigation ", (Throwable)E);
            return null;
        }
    }

    public static String getCurrentPortal() {
        return Util.getPortalRequestContext().getPortalOwner();
    }

    public static UserNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedUserNode();
    }
}

