/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBPageList;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.QueryBuilder;

public class StandardSQLDAO<T extends DBObject>
extends DAO<T> {
    protected Class<T> type_;

    public StandardSQLDAO(ExoDatasource datasource, Class<T> type) {
        super(datasource);
        this.type_ = type;
    }

    public StandardSQLDAO(ExoDatasource datasource, DBObjectMapper<T> mapper, Class<T> type) {
        super(datasource, mapper);
        this.type_ = type;
    }

    @Override
    public T createInstance() throws Exception {
        return (T)((DBObject)this.type_.newInstance());
    }

    @Override
    public T load(long id) throws Exception {
        return super.loadUnique(this.eXoDS_.getQueryBuilder().createSelectQuery(this.type_, id));
    }

    @Override
    public PageList loadAll() throws Exception {
        QueryBuilder queryBuilder = this.eXoDS_.getQueryBuilder();
        String query = queryBuilder.createSelectQuery(this.type_, -1L);
        StringBuilder queryCounter = new StringBuilder("SELECT COUNT(*) ");
        queryCounter.append(query.substring(query.indexOf("FROM")));
        return new DBPageList(20, this, query, queryCounter.toString());
    }

    @Override
    public void update(List<T> list) throws Exception {
        if (list == null) {
            throw new IllegalStateException("The given beans null ");
        }
        if (list.size() < 1) {
            return;
        }
        for (DBObject bean : list) {
            if (bean.getDBObjectId() >= 0L) continue;
            throw new IllegalStateException("The given bean " + bean.getClass() + " doesn't have an id");
        }
        this.execute(this.eXoDS_.getQueryBuilder().createUpdateQuery(this.type_), list);
    }

    @Override
    public void update(T bean) throws Exception {
        String query = this.eXoDS_.getQueryBuilder().createUpdateQuery(this.type_, ((DBObject)bean).getDBObjectId());
        this.execute(query, bean);
    }

    @Override
    public void save(List<T> list) throws Exception {
        if (list == null) {
            throw new IllegalStateException("The given beans null ");
        }
        if (list.size() < 1) {
            return;
        }
        for (DBObject bean : list) {
            if (bean.getDBObjectId() != -1L) continue;
            bean.setDBObjectId(this.eXoDS_.getIDGenerator().generateLongId(bean));
        }
        this.execute(this.eXoDS_.getQueryBuilder().createInsertQuery(this.type_), list);
    }

    @Override
    public void save(T bean) throws Exception {
        if (((DBObject)bean).getDBObjectId() == -1L) {
            ((DBObject)bean).setDBObjectId(this.eXoDS_.getIDGenerator().generateLongId(bean));
        }
        this.execute(this.eXoDS_.getQueryBuilder().createInsertQuery(bean.getClass(), ((DBObject)bean).getDBObjectId()), bean);
    }

    @Override
    public T remove(long id) throws Exception {
        T bean = this.load(id);
        if (bean == null) {
            return null;
        }
        this.execute(this.eXoDS_.getQueryBuilder().createRemoveQuery(this.type_, id), (DBObject)null);
        return bean;
    }

    @Override
    public void remove(T bean) throws Exception {
        this.execute(this.eXoDS_.getQueryBuilder().createRemoveQuery(this.type_, ((DBObject)bean).getDBObjectId()), (DBObject)null);
    }

    public Class<T> getType() {
        return this.type_;
    }
}

