/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.ProblemsPrinter;
import java.util.Arrays;
import java.util.List;

public class Less4jException
extends Exception {
    private static final int SHOW_ERRORS = 2;
    private final LessCompiler.CompilationResult partialResult;
    private final List<LessCompiler.Problem> errors;
    private final String message;

    public Less4jException(LessCompiler.Problem error, LessCompiler.CompilationResult partialResult) {
        this(Arrays.asList(error), partialResult);
    }

    public Less4jException(List<LessCompiler.Problem> errors, LessCompiler.CompilationResult partialResult) {
        this.errors = errors;
        this.partialResult = partialResult;
        this.message = this.createMessage();
    }

    public LessCompiler.CompilationResult getPartialResult() {
        return this.partialResult;
    }

    public List<LessCompiler.Problem> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private String createMessage() {
        ProblemsPrinter problemsPrinter = new ProblemsPrinter();
        StringBuilder builder = new StringBuilder("Could not compile less. ");
        builder.append(this.errors.size()).append(" error(s) occured:\n");
        List<LessCompiler.Problem> visibleErrors = ArraysUtils.safeSublist(this.errors, 0, 2);
        String visibleErrorsStr = problemsPrinter.printErrors(visibleErrors);
        builder.append(visibleErrorsStr);
        if (this.errors.size() > 2) {
            builder.append("...\n");
        }
        return builder.toString();
    }
}

