/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListsComparator {
    public <T> boolean equals(List<T> first, List<T> second, ListMemberComparator<T> comparator) {
        if (first.size() != second.size()) {
            return false;
        }
        Iterator<T> i1 = first.iterator();
        Iterator<T> i2 = second.iterator();
        while (i1.hasNext()) {
            T secondMember;
            T firstMember = i1.next();
            if (comparator.equals(firstMember, secondMember = i2.next())) continue;
            return false;
        }
        return true;
    }

    public <T> boolean prefix(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        if (lookFor.isEmpty()) {
            return true;
        }
        if (lookFor.size() > inList.size()) {
            return false;
        }
        List<T> relevantInList = ArraysUtils.sameLengthPrefix(inList, lookFor);
        List<T> relevantInListWithoutLast = ArraysUtils.sublistWithoutLast(relevantInList);
        List<T> lookForWithoutLast = ArraysUtils.sublistWithoutLast(lookFor);
        if (!this.equals(lookForWithoutLast, relevantInListWithoutLast, comparator)) {
            return false;
        }
        return comparator.prefix(ArraysUtils.last(lookFor), ArraysUtils.last(relevantInList));
    }

    public <T> MatchMarker<T> prefixMatches(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        if (lookFor.isEmpty() || lookFor.size() > inList.size()) {
            return null;
        }
        List<T> relevantInList = ArraysUtils.sameLengthPrefix(inList, lookFor);
        List<T> relevantInListWithoutLast = ArraysUtils.sublistWithoutLast(relevantInList);
        List<T> lookForWithoutLast = ArraysUtils.sublistWithoutLast(lookFor);
        if (!this.equals(lookForWithoutLast, relevantInListWithoutLast, comparator)) {
            return null;
        }
        boolean isPrefix = comparator.prefix(ArraysUtils.last(lookFor), ArraysUtils.last(relevantInList));
        if (isPrefix) {
            return new MatchMarker<T>(ArraysUtils.first(relevantInList), ArraysUtils.last(relevantInList), false);
        }
        return null;
    }

    public <T> T prefixEnd(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        if (lookFor.isEmpty()) {
            return inList.isEmpty() ? null : (T)inList.get(0);
        }
        if (lookFor.size() > inList.size()) {
            return null;
        }
        List<T> relevantInList = ArraysUtils.sameLengthPrefix(inList, lookFor);
        List<T> relevantInListWithoutLast = ArraysUtils.sublistWithoutLast(relevantInList);
        List<T> lookForWithoutLast = ArraysUtils.sublistWithoutLast(lookFor);
        if (!this.equals(lookForWithoutLast, relevantInListWithoutLast, comparator)) {
            return null;
        }
        if (comparator.prefix(ArraysUtils.last(lookFor), ArraysUtils.last(relevantInList))) {
            return ArraysUtils.last(relevantInList);
        }
        return null;
    }

    public <T> boolean suffix(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        return null != this.suffixMatches(lookFor, inList, comparator);
    }

    public <T> MatchMarker<T> suffixMatches(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        if (lookFor.isEmpty() || lookFor.size() > inList.size()) {
            return null;
        }
        List<T> relevantInList = ArraysUtils.sameLengthSuffix(inList, lookFor);
        List<T> relevantInListWithoutFirst = ArraysUtils.sublistWithoutFirst(relevantInList);
        List<T> lookForWithoutFirst = ArraysUtils.sublistWithoutFirst(lookFor);
        if (!this.equals(lookForWithoutFirst, relevantInListWithoutFirst, comparator)) {
            return null;
        }
        boolean isSuffix = comparator.suffix(ArraysUtils.first(lookFor), ArraysUtils.first(relevantInList));
        if (isSuffix) {
            return new MatchMarker<T>(ArraysUtils.first(relevantInList), ArraysUtils.last(relevantInList), false);
        }
        return null;
    }

    public <T> boolean contains(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        return !this.findMatches(lookFor, inList, comparator).isEmpty();
    }

    public <T> List<MatchMarker<T>> findMatches(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator) {
        return this.collectMatches((T)lookFor, inList, comparator, (List<MatchMarker<T>>)new ArrayList<MatchMarker<T>>());
    }

    public <T> List<MatchMarker<T>> collectMatches(List<T> lookFor, List<T> inList, ListMemberComparator<T> comparator, List<MatchMarker<T>> result) {
        boolean remainderIsPrefix;
        if (lookFor.isEmpty() || lookFor.size() > inList.size()) {
            return result;
        }
        if (lookFor.size() == 1) {
            return this.collectMatches(ArraysUtils.first(lookFor), inList, comparator, result);
        }
        T firstLookFor = ArraysUtils.first(lookFor);
        T firstInList = ArraysUtils.first(inList);
        List<T> remainderLookFor = ArraysUtils.sublistWithoutFirst(lookFor);
        List<T> remainderInList = ArraysUtils.sublistWithoutFirst(inList);
        boolean firstIsSuffix = comparator.suffix(firstLookFor, firstInList);
        T prefixEnd = this.prefixEnd(remainderLookFor, remainderInList, comparator);
        boolean bl = remainderIsPrefix = prefixEnd != null;
        if (firstIsSuffix && remainderIsPrefix) {
            result.add(new MatchMarker<T>(firstInList, prefixEnd, false));
        }
        this.collectMatches((T)lookFor, remainderInList, comparator, result);
        return result;
    }

    private <T> List<MatchMarker<T>> collectMatches(T lookFor, List<T> inParts, ListMemberComparator<T> comparator, List<MatchMarker<T>> result) {
        for (T inPart : inParts) {
            if (!comparator.contains(lookFor, inPart)) continue;
            result.add(new MatchMarker<T>(inPart, inPart, false));
        }
        return result;
    }

    public class MatchMarker<T> {
        private T first;
        private T last;
        private boolean isEquals;

        public MatchMarker(T first, T last, boolean isEquals) {
            this.first = first;
            this.last = last;
            this.isEquals = isEquals;
        }

        public T getFirst() {
            return this.first;
        }

        public void setFirst(T first) {
            this.first = first;
        }

        public T getLast() {
            return this.last;
        }

        public void setLast(T last) {
            this.last = last;
        }

        public boolean isEquals() {
            return this.isEquals;
        }

        public void setEquals(boolean isEquals) {
            this.isEquals = isEquals;
        }

        public boolean firstIsLast() {
            return this.first == this.last;
        }

        public boolean isIn(List<T> list) {
            return list.contains(this.getFirst()) && list.contains(this.getLast());
        }
    }

    public static interface ModifiedListBuilder<T> {
        public boolean splitInside(T var1, T var2, List<T> var3);

        public boolean cutSuffix(T var1, T var2, List<T> var3);

        public boolean cutPrefix(T var1, T var2, List<T> var3);
    }

    public static interface ListMemberComparator<T> {
        public boolean equals(T var1, T var2);

        public boolean prefix(T var1, T var2);

        public boolean suffix(T var1, T var2);

        public boolean contains(T var1, T var2);
    }
}

