/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;

public class OrganizationDatabaseInitializer
extends BaseComponentPlugin
implements OrganizationServiceInitializer,
ComponentPlugin {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.api.OrganizationDatabaseInitializer");
    private OrganizationConfig config_;
    protected static final int CHECK_EMPTY = 0;
    protected static final int CHECK_ENTRY = 1;
    private int checkDatabaseAlgorithm_ = 0;
    private boolean printInfo_;
    private boolean updateUsers_;

    public OrganizationDatabaseInitializer(InitParams params) throws Exception {
        String checkConfig = params.getValueParam("checkDatabaseAlgorithm").getValue();
        this.checkDatabaseAlgorithm_ = checkConfig.trim().equalsIgnoreCase("entry") ? 1 : 0;
        String printInfoConfig = params.getValueParam("printInformation").getValue();
        this.printInfo_ = printInfoConfig.trim().equalsIgnoreCase("true");
        ValueParam usParam = params.getValueParam("updateUsers");
        if (usParam != null) {
            String updateUsersParam = usParam.getValue();
            this.updateUsers_ = updateUsersParam != null && updateUsersParam.trim().equalsIgnoreCase("true");
        }
        this.config_ = (OrganizationConfig)params.getObjectParamValues(OrganizationConfig.class).get(0);
    }

    @Override
    public void init(OrganizationService service) throws Exception {
        if (this.checkDatabaseAlgorithm_ == 0 && this.checkExistDatabase(service)) {
            return;
        }
        String alg = "check empty database";
        if (this.checkDatabaseAlgorithm_ == 1) {
            alg = "check entry database";
        }
        this.printInfo("=======> Initialize the  organization service data  using algorithm " + alg);
        this.createGroups(service);
        this.createMembershipTypes(service);
        this.createUsers(service);
        this.printInfo("<=======");
    }

    protected boolean checkExistDatabase(OrganizationService service) throws Exception {
        PageList<User> users = service.getUserHandler().getUserPageList(10);
        return users != null && users.getAvailable() > 0;
    }

    protected void createGroups(OrganizationService orgService) throws Exception {
        this.printInfo("  Init  Group Data");
        List<?> groups = this.config_.getGroup();
        for (int i = 0; i < groups.size(); ++i) {
            OrganizationConfig.Group data = (OrganizationConfig.Group)groups.get(i);
            String groupId = null;
            String parentId = data.getParentId();
            groupId = parentId == null || parentId.length() == 0 ? "/" + data.getName() : data.getParentId() + "/" + data.getName();
            if (orgService.getGroupHandler().findGroupById(groupId) == null) {
                Group group = orgService.getGroupHandler().createGroupInstance();
                group.setGroupName(data.getName());
                group.setDescription(data.getDescription());
                group.setLabel(data.getLabel());
                if (parentId == null || parentId.length() == 0) {
                    orgService.getGroupHandler().addChild(null, group, true);
                } else {
                    Group parentGroup = orgService.getGroupHandler().findGroupById(parentId);
                    orgService.getGroupHandler().addChild(parentGroup, group, true);
                }
                this.printInfo("    Create Group " + groupId);
                continue;
            }
            this.printInfo("    Group " + groupId + " already exists, ignoring the entry");
        }
    }

    protected void createMembershipTypes(OrganizationService service) throws Exception {
        this.printInfo("  Init  Membership Type  Data");
        List<?> types = this.config_.getMembershipType();
        for (int i = 0; i < types.size(); ++i) {
            OrganizationConfig.MembershipType data = (OrganizationConfig.MembershipType)types.get(i);
            MembershipType membershipType = service.getMembershipTypeHandler().findMembershipType(data.getType());
            if (membershipType == null) {
                MembershipType type = service.getMembershipTypeHandler().createMembershipTypeInstance();
                type.setName(data.getType());
                type.setDescription(data.getDescription());
                service.getMembershipTypeHandler().createMembershipType(type, true);
                this.printInfo("    Created Membership Type " + data.getType());
                continue;
            }
            if (membershipType.getName().equals("*")) {
                membershipType.setDescription(data.getDescription());
                continue;
            }
            this.printInfo("    Membership Type " + data.getType() + " already exists, ignoring the entry");
        }
    }

    protected void createUsers(OrganizationService service) throws Exception {
        this.printInfo("  Init  User  Data");
        List<?> users = this.config_.getUser();
        MembershipHandler mhandler = service.getMembershipHandler();
        for (int i = 0; i < users.size(); ++i) {
            OrganizationConfig.User data = (OrganizationConfig.User)users.get(i);
            UserHandler handler = service.getUserHandler();
            User user = handler.findUserByName(data.getUserName(), UserStatus.ANY);
            if (user == null) {
                user = handler.createUserInstance(data.getUserName());
                user.setPassword(data.getPassword());
                user.setFirstName(data.getFirstName());
                user.setLastName(data.getLastName());
                user.setEmail(data.getEmail());
                user.setDisplayName(data.getDisplayName());
                handler.createUser(user, true);
                if (!data.isEnabled()) {
                    handler.setEnabled(user.getUserName(), false, true);
                }
                this.printInfo("    Created user " + data.getUserName());
            } else if (this.updateUsers_) {
                if (!user.isEnabled()) {
                    handler.setEnabled(user.getUserName(), true, true);
                }
                handler.saveUser(user, true);
                if (!data.isEnabled()) {
                    handler.setEnabled(user.getUserName(), false, true);
                }
                this.printInfo("    User " + data.getUserName() + " updated");
            } else {
                this.printInfo("    User " + data.getUserName() + " already exists, ignoring the entry");
            }
            String groups = data.getGroups();
            String[] entry = groups.split(",");
            for (int j = 0; j < entry.length; ++j) {
                String[] temp = entry[j].trim().split(":");
                String membership = temp[0];
                String groupId = temp[1];
                if (mhandler.findMembershipByUserGroupAndType(data.getUserName(), groupId, membership) == null) {
                    Group group = service.getGroupHandler().findGroupById(groupId);
                    MembershipType mt = service.getMembershipTypeHandler().createMembershipTypeInstance();
                    mt.setName(membership);
                    mhandler.linkMembership(user, group, mt, true);
                    this.printInfo("    Created membership " + data.getUserName() + ", " + groupId + ", " + membership);
                    continue;
                }
                this.printInfo("    Ignored membership " + data.getUserName() + ", " + groupId + ", " + membership);
            }
        }
    }

    protected void printInfo(String message) {
        if (this.printInfo_) {
            LOG.info((Object)message);
        }
    }

    protected OrganizationConfig getConfig() {
        return this.config_;
    }

    protected int getCheckDatabaseAlgorithm() {
        return this.checkDatabaseAlgorithm_;
    }

    protected boolean isPrintInfo() {
        return this.printInfo_;
    }

    public boolean isUpdateUsers() {
        return this.updateUsers_;
    }
}

