/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceInfo;
import org.exoplatform.social.webui.space.UISpaceMenu;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/UIAvatarUploadContent.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIAvatarUploadContent
extends UIContainer {
    private AvatarAttachment avatarAttachment;
    private String imageSource;

    public UIAvatarUploadContent() {
    }

    public UIAvatarUploadContent(AvatarAttachment avatarAttachment) throws Exception {
        this.avatarAttachment = avatarAttachment;
        this.setImageSource(avatarAttachment.getImageBytes());
    }

    public AvatarAttachment getAvatarAttachment() {
        return this.avatarAttachment;
    }

    public void setAvatarAttachment(AvatarAttachment avatarAttachment) throws Exception {
        this.avatarAttachment = avatarAttachment;
        this.setImageSource(avatarAttachment.getImageBytes());
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public void saveSpaceAvatar(UIAvatarUploadContent uiAvatarUploadContent, Space space) throws Exception {
        SpaceService spaceService = (SpaceService)uiAvatarUploadContent.getApplicationComponent(SpaceService.class);
        space.setEditor(Utils.getViewerRemoteId());
        space.setAvatarAttachment(uiAvatarUploadContent.getAvatarAttachment());
        spaceService.updateSpace(space);
        spaceService.updateSpaceAvatar(space);
    }

    public void saveUserAvatar(UIAvatarUploadContent uiAvatarUploadContent) throws Exception {
        AvatarAttachment attacthment = uiAvatarUploadContent.getAvatarAttachment();
        Profile p = Utils.getOwnerIdentity().getProfile();
        p.setProperty("avatar", (Object)attacthment);
        p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
        Map props = p.getProperties();
        for (String key : props.keySet()) {
            if (!key.startsWith("avatar_")) continue;
            p.removeProperty(key);
        }
        Utils.getIdentityManager().updateProfile(p);
    }

    private void setImageSource(byte[] imageBytes) throws Exception {
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource downloadResource = new InputStreamDownloadResource(byteImage, "image");
        downloadResource.setDownloadName(this.avatarAttachment.getFileName());
        this.imageSource = downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)downloadResource));
    }

    private class InputStreamDownloadResource
    extends DownloadResource {
        private InputStream is_;

        public InputStreamDownloadResource(ByteArrayInputStream byteImage, String resourceMimeType) {
            super(resourceMimeType);
            this.is_ = byteImage;
        }

        public InputStreamDownloadResource(String resourceMimeType) {
            super(resourceMimeType);
        }

        public InputStream getInputStream() throws IOException {
            return this.is_;
        }
    }

    public static class CancelActionListener
    extends EventListener<UIAvatarUploadContent> {
        public void execute(Event<UIAvatarUploadContent> event) throws Exception {
            UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploadContent.getParent();
            uiPopup.setShow(false);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIAvatarUploadContent> {
        public void execute(Event<UIAvatarUploadContent> event) throws Exception {
            UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)((Object)event.getSource());
            this.saveAvatar(uiAvatarUploadContent);
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploadContent.getParent();
            uiPopup.setShow(false);
            uiPopup.setUIComponent(null);
            uiPopup.setRendered(false);
            UIContainer container = (UIContainer)((UIPortletApplication)uiPopup.getAncestorOfType(UIPortletApplication.class)).findComponentById("Avatar");
            if (container != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)container);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
            } else {
                Utils.updateWorkingWorkSpace();
            }
        }

        private void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent) throws Exception {
            UISpaceInfo spaceInfo = (UISpaceInfo)uiAvatarUploadContent.getAncestorOfType(UISpaceInfo.class);
            UISpaceMenu spaceMenu = (UISpaceMenu)uiAvatarUploadContent.getAncestorOfType(UISpaceMenu.class);
            if (spaceInfo != null || spaceMenu != null) {
                String spaceUrl;
                SpaceService spaceService = (SpaceService)uiAvatarUploadContent.getApplicationComponent(SpaceService.class);
                Space space = spaceService.getSpaceByUrl(spaceUrl = Utils.getSpaceUrlByContext());
                if (space != null) {
                    uiAvatarUploadContent.saveSpaceAvatar(uiAvatarUploadContent, space);
                }
            } else {
                uiAvatarUploadContent.saveUserAvatar(uiAvatarUploadContent);
            }
        }
    }
}

