/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;

public class JavascriptManager {
    Log log = ExoLogger.getLogger((String)"portal:JavascriptManager");
    private FetchMap<ResourceId> resourceIds = new FetchMap();
    private Set<String> extendedScriptURLs = new LinkedHashSet<String>();
    private JavascriptConfigService javascriptConfigService;
    private StringBuilder scripts = new StringBuilder();
    private StringBuilder customizedOnloadJavascript = new StringBuilder();
    private RequireJS requireJS = new RequireJS();

    public JavascriptManager() {
        this.requireJS.require("SHARED/base", "base");
    }

    public void addJavascript(CharSequence s) {
        if (s != null) {
            this.scripts.append(s.toString().trim());
            this.scripts.append(";\n");
        }
    }

    public void loadScriptResource(String name) {
        this.loadScriptResource(ResourceScope.SHARED, name);
    }

    public void loadScriptResource(ResourceScope scope, String name) {
        if (scope == null) {
            throw new IllegalArgumentException("scope can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        ResourceId id = new ResourceId(scope, name);
        JavascriptConfigService service = this.getJavascriptConfigService();
        ScriptResource resource = service.getResource(id);
        if (resource != null) {
            if (FetchMode.IMMEDIATE.equals((Object)resource.getFetchMode())) {
                this.resourceIds.add(id, null);
            } else {
                HashMap<ResourceId, FetchMode> tmp = new HashMap<ResourceId, FetchMode>();
                tmp.put(id, null);
                for (ScriptResource res : service.resolveIds(tmp).keySet()) {
                    this.require(res.getId().toString());
                }
            }
        }
    }

    public FetchMap<ResourceId> getScriptResources() {
        return this.resourceIds;
    }

    public List<String> getExtendedScriptURLs() {
        return new LinkedList<String>(this.extendedScriptURLs);
    }

    public void addExtendedScriptURLs(String url) {
        this.extendedScriptURLs.add(url);
    }

    public void addOnLoadJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            StringBuilder script = new StringBuilder("base.Browser.addOnLoadCallback('mid");
            script.append(id);
            script.append("',");
            script.append(s instanceof String ? (String)s : s.toString());
            script.append(");");
            this.requireJS.addScripts(script.toString());
        }
    }

    public void addOnResizeJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            StringBuilder script = new StringBuilder();
            script.append("base.Browser.addOnResizeCallback('mid");
            script.append(id);
            script.append("',");
            script.append(s instanceof String ? (String)s : s.toString());
            script.append(");");
            this.requireJS.addScripts(script.toString());
        }
    }

    public void addOnScrollJavascript(CharSequence s) {
        if (s != null) {
            String id = Integer.toString(Math.abs(s.hashCode()));
            StringBuilder script = new StringBuilder();
            script.append("base.Browser.addOnScrollCallback('mid");
            script.append(id);
            script.append("',");
            script.append(s instanceof String ? (String)s : s.toString());
            script.append(");");
            this.requireJS.addScripts(script.toString());
        }
    }

    public void addCustomizedOnLoadScript(CharSequence s) {
        if (s != null) {
            this.customizedOnloadJavascript.append(s.toString().trim());
            this.customizedOnloadJavascript.append(";\n");
        }
    }

    public String getJavaScripts() {
        StringBuilder callback = new StringBuilder();
        callback.append((CharSequence)this.scripts);
        callback.append(this.requireJS.addScripts("base.Browser.onLoad();").addScripts(this.customizedOnloadJavascript.toString()).toString());
        return callback.toString();
    }

    public Map<String, Boolean> getPageScripts() {
        JavascriptConfigService service = this.getJavascriptConfigService();
        FetchMap<ResourceId> pageResourceIds = new FetchMap<ResourceId>();
        Set permanentResources = this.resourceIds.keySet();
        for (ResourceId resourceId : permanentResources) {
            pageResourceIds.add(resourceId);
        }
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        Set<String> noAlias = this.requireJS.getNoAlias();
        for (String string : noAlias) {
            Object[] moduleParts = StringUtils.split((String)string, (String)"/");
            ResourceId resourceId = new ResourceId(ResourceScope.valueOf(moduleParts[0]), StringUtils.join((Object[])moduleParts, (String)"/", (int)1, (int)moduleParts.length));
            pageResourceIds.add(resourceId);
        }
        Set<String> modulesWithAlias = this.requireJS.getDepends().keySet();
        for (String moduleAlias : modulesWithAlias) {
            String moduleId = this.requireJS.getDepends().get(moduleAlias);
            Object[] moduleParts = StringUtils.split((String)moduleId, (String)"/");
            ResourceId resourceId = new ResourceId(ResourceScope.valueOf(moduleParts[0]), StringUtils.join((Object[])moduleParts, (String)"/", (int)1, (int)moduleParts.length));
            pageResourceIds.add(resourceId);
        }
        Map<ScriptResource, FetchMode> map = service.resolveIds(pageResourceIds);
        for (ScriptResource rs : map.keySet()) {
            ResourceId id = rs.getId();
            Set<ResourceId> dependencies = service.getResource(id).getClosure();
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            result.put(id.toString(), isRemote);
            for (ResourceId dependencyId : dependencies) {
                ScriptResource dependencyResource = service.getResource(dependencyId);
                if (dependencyResource == null) continue;
                boolean isDependencyRemote = !dependencyResource.isEmpty() && dependencyResource.getModules().get(0) instanceof Module.Remote;
                result.put(dependencyId.toString(), isDependencyRemote);
            }
        }
        for (String url : this.getExtendedScriptURLs()) {
            result.put(url, true);
        }
        return result;
    }

    public RequireJS require(String moduleId) {
        return this.require(moduleId, null);
    }

    public RequireJS require(String moduleId, String alias) {
        return this.requireJS.require(moduleId, alias);
    }

    public RequireJS getRequireJS() {
        return this.requireJS;
    }

    public String generateUUID() {
        return "uniq-" + UUID.randomUUID().toString();
    }

    public JavascriptConfigService getJavascriptConfigService() {
        if (this.javascriptConfigService == null) {
            this.javascriptConfigService = (JavascriptConfigService)ExoContainerContext.getService(JavascriptConfigService.class);
        }
        return this.javascriptConfigService;
    }
}

