/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.utils.MentionUtils;

public class MentionsProcessor
extends BaseActivityProcessorPlugin {
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    private UserPortalConfigService userPortalConfigService;

    public MentionsProcessor(InitParams params, UserPortalConfigService userPortalConfigService) {
        super(params);
        this.userPortalConfigService = userPortalConfigService;
    }

    @Override
    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            String portalOwner = CommonsUtils.getCurrentPortalOwner();
            activity.setTitle(MentionUtils.substituteUsernames(portalOwner, activity.getTitle()));
            activity.setBody(MentionUtils.substituteUsernames(portalOwner, activity.getBody()));
            Map<String, String> templateParams = activity.getTemplateParams();
            if (templateParams.containsKey("MESSAGE")) {
                templateParams.put("registeredKeysForProcessor", "MESSAGE");
            }
            List<String> templateParamKeys = this.getTemplateParamKeysToFilter(activity);
            for (String key : templateParamKeys) {
                templateParams.put(key, MentionUtils.substituteUsernames(portalOwner, templateParams.get(key)));
            }
        }
    }
}

