/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.util.HashMap;
import org.apache.pdfbox.util.ICU4JImpl;

public class TextNormalize {
    private ICU4JImpl icu4j = null;
    private static final HashMap<Integer, String> DIACHASH = new HashMap();
    private String outputEncoding;

    public TextNormalize(String encoding) {
        this.findICU4J();
        this.outputEncoding = encoding;
    }

    private void findICU4J() {
        try {
            this.getClass().getClassLoader().loadClass("com.ibm.icu.text.Bidi");
            this.getClass().getClassLoader().loadClass("com.ibm.icu.text.Normalizer");
            this.icu4j = new ICU4JImpl();
        }
        catch (ClassNotFoundException e) {
            this.icu4j = null;
        }
    }

    private static void populateDiacHash() {
        DIACHASH.put(new Integer(96), "\u0300");
        DIACHASH.put(new Integer(715), "\u0300");
        DIACHASH.put(new Integer(39), "\u0301");
        DIACHASH.put(new Integer(697), "\u0301");
        DIACHASH.put(new Integer(714), "\u0301");
        DIACHASH.put(new Integer(94), "\u0302");
        DIACHASH.put(new Integer(710), "\u0302");
        DIACHASH.put(new Integer(126), "\u0303");
        DIACHASH.put(new Integer(713), "\u0304");
        DIACHASH.put(new Integer(176), "\u030a");
        DIACHASH.put(new Integer(698), "\u030b");
        DIACHASH.put(new Integer(711), "\u030c");
        DIACHASH.put(new Integer(712), "\u030d");
        DIACHASH.put(new Integer(34), "\u030e");
        DIACHASH.put(new Integer(699), "\u0312");
        DIACHASH.put(new Integer(700), "\u0313");
        DIACHASH.put(new Integer(1158), "\u0313");
        DIACHASH.put(new Integer(1370), "\u0313");
        DIACHASH.put(new Integer(701), "\u0314");
        DIACHASH.put(new Integer(1157), "\u0314");
        DIACHASH.put(new Integer(1369), "\u0314");
        DIACHASH.put(new Integer(724), "\u031d");
        DIACHASH.put(new Integer(725), "\u031e");
        DIACHASH.put(new Integer(726), "\u031f");
        DIACHASH.put(new Integer(727), "\u0320");
        DIACHASH.put(new Integer(690), "\u0321");
        DIACHASH.put(new Integer(716), "\u0329");
        DIACHASH.put(new Integer(695), "\u032b");
        DIACHASH.put(new Integer(717), "\u0331");
        DIACHASH.put(new Integer(95), "\u0332");
        DIACHASH.put(new Integer(8270), "\u0359");
    }

    public String makeLineLogicalOrder(String str, boolean isRtlDominant) {
        if (this.icu4j != null) {
            return this.icu4j.makeLineLogicalOrder(str, isRtlDominant);
        }
        return str;
    }

    public String normalizePres(String str) {
        if (this.icu4j != null) {
            return this.icu4j.normalizePres(str);
        }
        return str;
    }

    public String normalizeDiac(String str) {
        if (this.outputEncoding != null && this.outputEncoding.toUpperCase().startsWith("UTF")) {
            Integer c = new Integer(str.charAt(0));
            if (DIACHASH.containsKey(c)) {
                return DIACHASH.get(c);
            }
            if (this.icu4j != null) {
                return this.icu4j.normalizeDiac(str);
            }
            return str;
        }
        return str;
    }

    static {
        TextNormalize.populateDiacHash();
    }
}

