/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import thredds.wcs.v1_0_0_Plus.WcsCoverage;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcsDataset {
    private String datasetPath;
    private String datasetName;
    private GridDataset dataset;
    private HashMap<String, WcsCoverage> availableCoverages;

    public WcsDataset(GridDataset dataset, String datasetPath) {
        this.datasetPath = datasetPath;
        int pos = datasetPath.lastIndexOf("/");
        this.datasetName = pos > 0 ? datasetPath.substring(pos + 1) : datasetPath;
        this.dataset = dataset;
        this.availableCoverages = new HashMap();
        for (GridDataset.Gridset curGridset : this.dataset.getGridsets()) {
            GridCoordSystem gcs = curGridset.getGeoCoordSystem();
            if (!gcs.isRegularSpatial()) continue;
            this.availableCoverages.put(gcs.getName(), new WcsCoverage(curGridset, this));
        }
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public GridDataset getDataset() {
        return this.dataset;
    }

    public boolean isAvailableCoverageName(String name) {
        return this.availableCoverages.containsKey(name);
    }

    public WcsCoverage getAvailableCoverage(String name) {
        return this.availableCoverages.get(name);
    }

    public Collection<WcsCoverage> getAvailableCoverageCollection() {
        return Collections.unmodifiableCollection(this.availableCoverages.values());
    }
}

