/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ActivityLifeCycle
extends AbstractLifeCycle<ActivityListener, ActivityLifeCycleEvent> {
    protected void dispatchEvent(ActivityListener listener, ActivityLifeCycleEvent event) {
        switch (event.getType()) {
            case SAVE_ACTIVITY: {
                listener.saveActivity(event);
                break;
            }
            case UPDATE_ACTIVITY: {
                listener.updateActivity(event);
                break;
            }
            case SAVE_COMMENT: {
                listener.saveComment(event);
                break;
            }
            case UPDATE_COMMENT: {
                listener.updateComment(event);
                break;
            }
            case LIKE_ACTIVITY: {
                listener.likeActivity(event);
                break;
            }
            case LIKE_COMMENT: {
                listener.likeComment(event);
                break;
            }
            case DELETE_COMMENT: {
                listener.deleteComment(event);
                break;
            }
            case DELETE_ACTIVITY: {
                listener.deleteActivity(event);
            }
        }
    }

    public void saveActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.SAVE_ACTIVITY, activity));
    }

    public void updateActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_ACTIVITY, activity));
    }

    public void saveComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.SAVE_COMMENT, activity));
    }

    public void updateComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_COMMENT, activity));
    }

    public void likeActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.LIKE_ACTIVITY, activity));
    }

    public void likeComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.LIKE_COMMENT, activity));
    }

    public void deleteActivity(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_ACTIVITY, activity));
    }

    public void deleteComment(ExoSocialActivity activity) {
        this.broadcast(new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.DELETE_COMMENT, activity));
    }
}

