/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.resource;

import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.simple.JSONObject;

@Path(value="/i18n/bundle")
public class ResourceBundleREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ResourceBundleREST.class);
    private ResourceBundleService resourceBundleService;
    private LocaleConfigService localeConfigService;
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final Date DEFAULT_LAST_MODIFED = new Date();
    private static final int CACHE_IN_SECONDS = 43200;
    private static final int CACHE_IN_MILLI_SECONDS = 43200000;

    public ResourceBundleREST(ResourceBundleService resourceBundleService, LocaleConfigService localeConfigService) {
        this.resourceBundleService = resourceBundleService;
        this.localeConfigService = localeConfigService;
        CACHE_CONTROL.setMaxAge(43200);
    }

    @GET
    @Path(value="{name}-{lang}.json")
    @Produces(value={"application/json"})
    public Response getBundleContent(@PathParam(value="name") String resourceBundleName, @PathParam(value="lang") String lang) {
        String key;
        if (StringUtils.isBlank((CharSequence)resourceBundleName) || StringUtils.isBlank((CharSequence)lang)) {
            return Response.status((int)400).build();
        }
        LocaleConfig localeConfig = this.localeConfigService.getLocaleConfig(lang);
        if (localeConfig == null) {
            LOG.warn("Locale '{}' is not supported", new Object[]{lang});
            return Response.status((int)400).build();
        }
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(resourceBundleName, localeConfig.getLocale());
        ResourceBundle defaultResourceBundle = this.resourceBundleService.getResourceBundle(resourceBundleName, this.localeConfigService.getDefaultLocaleConfig().getLocale());
        if (resourceBundle == null) {
            if (defaultResourceBundle == null) {
                LOG.warn("resourceBundleName '{}' wasn't found", new Object[]{resourceBundleName});
                return Response.status((int)404).build();
            }
            resourceBundle = defaultResourceBundle;
        }
        JSONObject resultJSON = new JSONObject();
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            resultJSON.put((Object)key, (Object)resourceBundle.getString(key));
        }
        keys = defaultResourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            resultJSON.putIfAbsent((Object)key, (Object)resourceBundle.getString(key));
        }
        Response.ResponseBuilder builder = Response.ok((Object)resultJSON.toJSONString(), (String)"application/json");
        if (!PropertyManager.isDevelopping()) {
            builder.cacheControl(CACHE_CONTROL).lastModified(DEFAULT_LAST_MODIFED).expires(new Date(System.currentTimeMillis() + 43200000L));
        }
        return builder.build();
    }
}

